package com.clx.performance.controller.pc.integral;

import com.clx.performance.param.pc.integral.IntegralRuleUpdateParam;
import com.clx.performance.service.integral.IntegralRuleService;
import com.clx.performance.vo.pc.integral.AppIntegralRuleVO;
import com.msl.common.convertor.aspect.UnitCovert;
import com.msl.common.result.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

@Slf4j
@RestController
@RequestMapping(value="/pc/carrier/integral/rule")
@Validated
@Api(tags = "司机APP-积分规则")
@AllArgsConstructor
public class IntegralRuleController {

    @Autowired
    private IntegralRuleService integralRuleService;

    @ApiOperation(value = "更新车辆层级配置", notes = "<br>By:艾庆国")
    @PostMapping("/updateRule")
    @UnitCovert
    public Result<Void> updateRule(@RequestBody @Validated IntegralRuleUpdateParam param) {
        integralRuleService.updateRule(param);

        return Result.ok();
    }

    @ApiOperation(value = "查询车辆层级配置信息", notes = "<br>By:艾庆国")
    @GetMapping(value = "getRuleInfo")
    @UnitCovert(param = false)
    public Result<AppIntegralRuleVO> getRuleInfo() {

        return Result.ok(integralRuleService.getRuleInfo());
    }

}
