package com.clx.performance.vo.pc.integral;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
* @Author: aiqinguo
* @Description: 车辆积分规则
* @Date: 2023/11/06 14:12:53
* @Version: 1.0
*/

@ApiModel(description = "积分规则")
@Getter
@Setter
@ToString
@NoArgsConstructor
public class AppIntegralRuleVO {

    @ApiModelProperty(value = "运单完成积分规则")
    private OrderChildCompleteRule orderChildCompleteRule;
    @ApiModelProperty(value = "货单奖励积分规则")
    private OrderAwardRule orderAwardRule;
    @ApiModelProperty(value = "货单扣减积分规则")
    private OrderDiscountRule orderDiscountRule;
    @ApiModelProperty(value = "运单超时扣减规则")
    private OrderChildTimeoutRule orderChildTimeoutRule;
    @ApiModelProperty(value = "平台补偿积分规则")
    private PlatformCompensationRule platformCompensationRule;


    @Getter
    @Setter
    @ToString
    @NoArgsConstructor
    public static class OrderChildCompleteRule{
        @ApiModelProperty(value = "当日完成第1笔运单积分x")
        private Integer integer1;
        @ApiModelProperty(value = "当日完成第2笔运单积分x")
        private Integer integer2;
        @ApiModelProperty(value = "当日完成第3笔运单积分x")
        private Integer integer3;
        @ApiModelProperty(value = "当日完成第4笔运单积分x")
        private Integer integer4;
        @ApiModelProperty(value = "当日完成第5笔运单积分x")
        private Integer integer5;
    }
    @Getter
    @Setter
    @ToString
    @NoArgsConstructor
    public static class OrderAwardRule{
        @ApiModelProperty(value = "完成流水单每单附加积分x")
        private Integer integerWater;
        @ApiModelProperty(value = "当日流水单奖励次数上限x")
        private Integer countWaterLimit;

        @ApiModelProperty(value = "完成支援单每单附加积分x")
        private Integer integerSupport;
        @ApiModelProperty(value = "当日支援单奖励次数上限x")
        private Integer countSupportLimit;
    }
    @Getter
    @Setter
    @ToString
    @NoArgsConstructor
    public static class OrderDiscountRule{
        @ApiModelProperty(value = "自行取消运单每单扣减积分x")
        private Integer integralCancel;
        @ApiModelProperty(value = "自行取消流水单每单另扣积分x")
        private Integer integralWaterCancel;
        @ApiModelProperty(value = "自行取消支援单每单另扣积分x")
        private Integer integralSupportCancel;
    }
    @Getter
    @Setter
    @ToString
    @NoArgsConstructor
    public static class OrderChildTimeoutRule{
        @ApiModelProperty(value = "超时未到达货源地扣积分x")
        private Integer integralSendAddressTimeout;
        @ApiModelProperty(value = "超时未到达目的地扣积分x")
        private Integer integralReceiveAddressTimeout;
        @ApiModelProperty(value = "接单超时扣积分x")
        private Integer integralTakeOrderTimeout;
    }
    @Getter
    @Setter
    @ToString
    @NoArgsConstructor
    public static class PlatformCompensationRule{
        @ApiModelProperty(value = "平台取消运单补偿积分x")
        private Integer integralCancel;
        @ApiModelProperty(value = "当日平台补偿积分上限x")
        private Integer integralCancelLimit;
        @ApiModelProperty(value = "规定时间不能装车补偿x")
        private Integer integralLoad;
        @ApiModelProperty(value = "规定时间不能卸车补偿x")
        private Integer integralUnload;
    }


    @ApiModelProperty(value = "运单完成积分规则", example = "", hidden = true)
    private OrderChildCompleteRule orderChildCompleteRuleJson;
    @ApiModelProperty(value = "货单奖励积分规则", example = "", hidden = true)
    private OrderAwardRule orderAwardRuleJson;
    @ApiModelProperty(value = "货单扣减积分规则", example = "", hidden = true)
    private OrderDiscountRule orderDiscountRuleJson;
    @ApiModelProperty(value = "运单超时扣减规则", example = "", hidden = true)
    private OrderChildTimeoutRule orderChildTimeoutRuleJson;
    @ApiModelProperty(value = "平台补偿积分规则", example = "", hidden = true)
    private PlatformCompensationRule platformCompensationRuleJson;

}