package com.clx.performance.vo.app.collect;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
* @Author: aiqinguo
* @Description: 线路排队耗时
* @Date: 2023/10/16 13:06:27
* @Version: 1.0
*/

@ApiModel(description = "线路排队耗时")
@Getter
@Setter
@ToString
@NoArgsConstructor
public class CollectTruckWaitVO {

    @ApiModelProperty(value = "id", example = "")
    private Integer id;
    @ApiModelProperty(value = "用户编号", example = "")
    private Long userNo;
    @ApiModelProperty(value = "用户姓名", example = "")
    private String name;
    @ApiModelProperty(value = "手机号码", example = "")
    private String mobile;
    @ApiModelProperty(value = "车牌号", example = "")
    private String truckNo;
    @ApiModelProperty(value = "运单编号", example = "")
    private String childNo;
    @ApiModelProperty(value = "地址id", example = "")
    private Integer addressId;
    @ApiModelProperty(value = "详细地址", example = "")
    private String address;
    @ApiModelProperty(value = "上报类型：1 装车类型 2卸车类型", example = "")
    private Integer reportType;
    @ApiModelProperty(value = "上报类型：1 需要排队 ", example = "")
    private Integer waitType;
    @ApiModelProperty(value = "预计站内等待时长", example = "")
    private BigDecimal stationInTime;
    @ApiModelProperty(value = "预计站内等待时长图片", example = "")
    private String stationInImage;
    @ApiModelProperty(value = "预计站外等待时长", example = "")
    private BigDecimal stationOutTime;
    @ApiModelProperty(value = "预计站外等待时长图片", example = "")
    private String stationOutImage;
    @ApiModelProperty(value = "上报时间", example = "")
    private String reportTime;
    @ApiModelProperty(value = "创建时间", example = "")
    private String createTime;
    @ApiModelProperty(value = "修改时间", example = "")
    private String modifiedTime;

}