package com.clx.performance.param.pc.integral;

import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

import java.math.BigDecimal;

/**
 * @Author: aiqingguo
 * @Description: 新增积分
 * @Date: 2023-10-11 17:30:57
 * @Version: 1.0
 */
@Setter
@Getter
@ToString
@NoArgsConstructor
public class IntegralTruckRuleSaveParam {

    @ApiModelProperty(value = "层级名称", example = "")
    private String name;
    @ApiModelProperty(value = "积分起始范围", example = "")
    private Integer integralRatioBegin;
    @ApiModelProperty(value = "积分结束范围", example = "")
    private Integer integralRatioEnd;
    @ApiModelProperty(value = "状态：1开启 2关闭", example = "")
    private Integer status;
    @ApiModelProperty(value = "预期收益开始范围（分）", example = "")
    private BigDecimal incomeBegin;
    @ApiModelProperty(value = "预期收益结束范围（分）", example = "")
    private BigDecimal incomeEnd;

}
