package com.clx.performance.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.msl.common.config.KeyColumn;
import com.msl.common.model.HasKey;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;
import java.util.Date;

import lombok.Data;


/**
 * @author yangqifa
 */
@Data
public class OcrRecognition implements HasKey<Integer> {
    /**
     * 主键ID
     */
    @TableId(value = "id", type = IdType.AUTO)
    @ApiModelProperty(value = "主键ID")
    private Integer id;

    /**
     * 运单编号
     */
    @ApiModelProperty(value = "运单编号")
    private String childNo;

    /**
     * 图片类型,1:装车磅单,2:卸车磅单
     */
    @ApiModelProperty(value = "图片类型,1:装车磅单,2:卸车磅单")
    private Integer imageType;

    /**
     * 磅单图片url
     */
    @ApiModelProperty(value = "磅单图片url")
    private String imageUrl;

    /**
     * 毛重
     */
    @ApiModelProperty(value = "毛重")
    private BigDecimal grossWeight;

    /**
     * 皮重
     */
    @ApiModelProperty(value = "皮重")
    private BigDecimal tareWeight;

    /**
     * OCR识别的原始结果
     */
    @ApiModelProperty(value = "OCR识别的原始结果")
    private String originalResult;

    /**
     * 创建时间
     */
    @ApiModelProperty(value = "创建时间")
    private Date createdTime;

    /**
     * 更新时间
     */
    @ApiModelProperty(value = "更新时间")
    private Date modifiedTime;

    @KeyColumn("id")
    @Override
    public Integer gainKey() {
        return id;
    }
}