package com.clx.performance.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.msl.common.config.KeyColumn;
import com.msl.common.model.HasKey;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import java.time.LocalDateTime;

/**
 * @author Min
 * Date 2024-06-14
 * Time 11:51
 */
@Getter
@Setter
@Accessors(chain = true)
@TableName("app")
public class App  implements HasKey<Integer> {

    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    @TableField("unique_identifier")
    @ApiModelProperty("唯一标识 1:场站-smart-weight")
    private Integer uniqueIdentifier;

    @TableField("name")
    @ApiModelProperty("应用名称")
    private String name;

    @TableField("namespace")
    @ApiModelProperty("命名空间")
    private String namespace;

    @TableField("app_no")
    @ApiModelProperty("应用标识")
    private String appNo;

    @TableField("app_key")
    @ApiModelProperty("应用密钥")
    private String appKey;

    @TableField("callback")
    @ApiModelProperty("回调网关")
    private String callback;

    @TableField("create_time")
    @ApiModelProperty("创建时间")
    private LocalDateTime createTime;                      //

    @TableField("modified_time")
    @ApiModelProperty("修改时间")
    private LocalDateTime modifiedTime;


    @KeyColumn("id")
    public Integer gainKey() {
        return this.id;
    }

}
