package com.clx.performance.listener.excel;

import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.event.AnalysisEventListener;
import com.clx.performance.dto.excel.InvoiceData;
import lombok.AllArgsConstructor;

import java.util.List;

@AllArgsConstructor
public class InvoiceDataListener extends AnalysisEventListener<InvoiceData> {

    private final List<InvoiceData> invoiceDataList;

    @Override
    public void invoke(InvoiceData invoiceData, AnalysisContext context) {
        // 每解析一行都会调用一次，逐行校验数据

        invoiceDataList.add(invoiceData);
    }

    @Override
    public void doAfterAllAnalysed(AnalysisContext context) {
        // 解析完成后调用
        // 可在此进行后续操作，如保存数据到数据库
    }
}

