package com.clx.performance.controller.pc.carrier;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.clx.performance.enums.PerformanceResultEnum;
import com.clx.performance.param.pc.carrier.CarrierSettlementOwnerDetailCompanyUpdateParam;
import com.clx.performance.param.pc.carrier.ExportBatchOwnerSettlementDetailParam;
import com.clx.performance.param.pc.owner.PageCarrierSettlementOwnerDetailParam;
import com.clx.performance.param.pc.owner.PageInvoiceOwnerSettlementOwnerDetailParam;
import com.clx.performance.param.pc.owner.PageOwnerSettlementOwnerDetailParam;
import com.clx.performance.param.pc.owner.PagePendingCarrierSettlementOwnerDetailParam;
import com.clx.performance.service.settle.SettlementOwnerDetailService;
import com.clx.performance.vo.pc.carrier.settle.CarrierPagePendingSettlementOwnerDetailVO;
import com.clx.performance.vo.pc.carrier.settle.CarrierPageSettlementOwnerDetailVO;
import com.clx.performance.vo.pc.owner.settle.CountOwnerSettlementOwnerDetailVO;
import com.clx.performance.vo.pc.owner.settle.PageOwnerSettlementOwnerDetailVO;
import com.clx.performance.vo.pc.owner.settle.UploadBatchInvoiceFileResultVO;
import com.msl.common.base.PageData;
import com.msl.common.convertor.aspect.UnitCovert;
import com.msl.common.exception.ServiceSystemException;
import com.msl.common.result.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;

@Slf4j
@RestController
@RequestMapping(value="/pc/carrier/settlementOwnerDetail")
@Validated
@Api(tags = "承运端-计费管理")
@AllArgsConstructor
public class CarrierSettlementOwnerDetailController {

    private final SettlementOwnerDetailService settlementOwnerDetailService;


    @ApiOperation(value = "运单计费列表（货主）",notes = "<br>By:刘海泉")
    @PostMapping("/pageSettlementOwnerDetail")
    @UnitCovert(param = false)
    public Result<PageData<CarrierPageSettlementOwnerDetailVO>> pageSettlementOwnerDetail(@RequestBody @Validated PageCarrierSettlementOwnerDetailParam param) {
        IPage<CarrierPageSettlementOwnerDetailVO> page = settlementOwnerDetailService.pageSettlementOwnerDetail(param);
        return Result.page(page.getRecords(),page.getTotal(),page.getPages());
    }

    @ApiOperation(value = "货主结算单运单明细",notes = "<br>By:姜文业")
    @PostMapping("/pageOwnerSettlementOrderDetailList")
    @UnitCovert(param = false)
    public Result<PageData<PageOwnerSettlementOwnerDetailVO>> pageOwnerSettlementOrderDetailList(@RequestBody @Validated PageOwnerSettlementOwnerDetailParam param) {
        IPage<PageOwnerSettlementOwnerDetailVO> page = settlementOwnerDetailService.pageOwnerSettlementOrderDetailList(param);
        return Result.page(page.getRecords(),page.getTotal(),page.getPages());
    }

    @ApiOperation(value = "开票管理待开票、已开票列表",notes = "<br>By:杨启发")
    @PostMapping("/pageInvoiceOwnerSettlementOrderDetailList")
    @UnitCovert(param = false)
    public Result<PageData<PageOwnerSettlementOwnerDetailVO>> pageInvoiceOwnerSettlementOrderDetailList(@RequestBody @Validated PageInvoiceOwnerSettlementOwnerDetailParam param) {
        IPage<PageOwnerSettlementOwnerDetailVO> page = settlementOwnerDetailService.pageInvoiceOwnerSettlementOrderDetailList(param);
        return Result.page(page.getRecords(),page.getTotal(),page.getPages());
    }

    @ApiOperation(value = "开票管理待开票、已开票列表统计",notes = "<br>By:杨启发")
    @PostMapping("/countInvoiceOwnerSettlementOrderDetailList")
    public Result<CountOwnerSettlementOwnerDetailVO> countInvoiceOwnerSettlementOrderDetailList(@RequestBody @Validated PageInvoiceOwnerSettlementOwnerDetailParam param) {
        CountOwnerSettlementOwnerDetailVO vo = settlementOwnerDetailService.countInvoiceOwnerSettlementOrderDetailList(param);
        return Result.ok(vo);
    }

    @ApiOperation(value = "导出开票管理待开票、已开票",notes = "<br>By:杨启发")
    @PostMapping("/exportInvoiceOwnerSettlementOrderDetail")
    public void exportInvoiceOwnerSettlementOrderDetail(@RequestBody @Validated PageInvoiceOwnerSettlementOwnerDetailParam param, HttpServletResponse response) throws Exception {
        try (SXSSFWorkbook workbook = settlementOwnerDetailService.exportInvoiceOwnerSettlementOrderDetail(param)) {
            response.setHeader(HttpHeaders.CONTENT_TYPE, MediaType.APPLICATION_OCTET_STREAM_VALUE);
            workbook.write(response.getOutputStream());
        }
    }

    @ApiOperation(value = "上传批量开票文件",notes = "<br>By:杨启发")
    @PostMapping("/uploadBatchInvoiceFile")
    public Result<UploadBatchInvoiceFileResultVO> uploadBatchInvoiceFile(@RequestParam("file") MultipartFile file) throws IOException {
        return Result.ok(settlementOwnerDetailService.uploadBatchInvoiceFile(file));
    }

    @ApiOperation(value = "导出货主结算单运单明细",notes = "<br>By:姜文业")
    @PostMapping("/exportOwnerSettlementOrderDetailList")
    public void exportCarrierSettlementOwnerPageList(@RequestBody @Validated PageOwnerSettlementOwnerDetailParam param, HttpServletResponse response) throws Exception {
        SXSSFWorkbook workbook = settlementOwnerDetailService.exportOwnerSettlementOrderDetail(param);
        response.setHeader(HttpHeaders.CONTENT_TYPE, MediaType.APPLICATION_OCTET_STREAM_VALUE);
        workbook.write(response.getOutputStream());
    }

    @ApiOperation(value = "待处理运单计费列表（货主）",notes = "<br>By:杨启发")
    @PostMapping("/pagePendingSettlementOwnerDetail")
    @UnitCovert(param = false)
    public Result<PageData<CarrierPagePendingSettlementOwnerDetailVO>> pagePendingSettlementOwnerDetail(@RequestBody @Validated PagePendingCarrierSettlementOwnerDetailParam param) {
        IPage<CarrierPagePendingSettlementOwnerDetailVO> page = settlementOwnerDetailService.pagePendingSettlementOwnerDetail(param);
        return Result.page(page.getRecords(),page.getTotal(),page.getPages());
    }

    @ApiOperation(value = "导出货主待处理运单计费",notes = "<br>By:杨启发")
    @PostMapping("/exportPendingSettlementOwnerDetail")
    public void exportPendingSettlementOwnerDetail(@RequestBody @Validated PagePendingCarrierSettlementOwnerDetailParam param, HttpServletResponse response) throws Exception {
        try (SXSSFWorkbook workbook = settlementOwnerDetailService.exportPendingSettlementOwnerDetail(param)) {
            response.setHeader(HttpHeaders.CONTENT_TYPE, MediaType.APPLICATION_OCTET_STREAM_VALUE);
            workbook.write(response.getOutputStream());
        }
    }


    @ApiOperation(value = "批量下载结算运单明细",notes = "<br>By:liruixin")
    @PostMapping("/exportBatchSettlementOwnerDetail")
    public void exportBatchSettlementOwnerDetail(@RequestBody @Validated ExportBatchOwnerSettlementDetailParam param, HttpServletResponse response) throws Exception {
        if(CollectionUtil.isEmpty(param.getSettlementNos())){
            throw new ServiceSystemException(PerformanceResultEnum.SETTLEMENT_NO_NULL_ERROR);
        }
        SXSSFWorkbook workbook = settlementOwnerDetailService.exportBatchSettlementOwnerDetail(param);
        response.setHeader(HttpHeaders.CONTENT_TYPE, MediaType.APPLICATION_OCTET_STREAM_VALUE);
        workbook.write(response.getOutputStream());

    }

    @ApiOperation(value = "更新开票公司",notes = "<br>By:艾庆国")
    @PostMapping("/updateInvoiceCompany")
    public Result updateInvoiceCompany(@RequestBody @Validated CarrierSettlementOwnerDetailCompanyUpdateParam param) {
        settlementOwnerDetailService.updateInvoiceCompany(param);
        return Result.ok();
    }

}
