package com.clx.performance.controller.pc.breakcontract.carrier;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.clx.performance.param.pc.breakcontract.carrier.BreakContractDriverRecordAddParam;
import com.clx.performance.param.pc.breakcontract.carrier.PageBreakContractDriverRecordParam;
import com.clx.performance.service.breakcontract.BreakContractDriverRecordService;
import com.clx.performance.vo.pc.breakcontract.carrier.BreakContractDriverRecordVO;
import com.msl.common.base.PageData;
import com.msl.common.convertor.aspect.UnitCovert;
import com.msl.common.result.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.validation.constraints.NotBlank;

@Slf4j
@RestController
@RequestMapping(value="/pc/carrier/breakContract/driverRecord")
@Validated
@Api(tags = "承运端-司机违约管理")
@AllArgsConstructor
public class CarrierBreakContractDriverRecordController {

    private final BreakContractDriverRecordService breakContractDriverRecordService;


    @ApiOperation(value = "新增违约记录", notes = "<br>By:艾庆国")
    @PostMapping("/saveRecord")
    @UnitCovert
    public Result<Void> saveRecord(@RequestBody @Validated BreakContractDriverRecordAddParam param) {
        breakContractDriverRecordService.saveRecord(param);

        return Result.ok();
    }

    @ApiOperation(value = "分页搜索违约列表",notes = "<br>By:艾庆国")
    @PostMapping("/pageRecord")
    @UnitCovert(param = false)
    public Result<PageData<BreakContractDriverRecordVO>> pageRecord(@RequestBody @Validated PageBreakContractDriverRecordParam param) {
        IPage<BreakContractDriverRecordVO> page = breakContractDriverRecordService.pageRecord(param);
        return Result.page(page.getRecords(), page.getTotal(), page.getPages());
    }


    @ApiOperation(value = "获取运单的用车需求（是否自由车辆）",notes = "<br>By:刘海泉")
    @GetMapping("/getChildTruckDemand")
    public Result<Integer> getChildTruckDemand(@ApiParam("运单编号") @NotBlank(message = "运单编号不能为空") String childNo) {
        return Result.ok(breakContractDriverRecordService.getChildTruckDemand(childNo));
    }


}
