/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsign.base.util;

import cn.com.infosec.netsign.exceptions.DERDecodeException;

public class DERBytes {
    private int length;
    private int tag;
    private int contentOffset;
    private int contentLength;

    public DERBytes(byte[] data, int offset) throws DERDecodeException {
        if (offset + 2 > data.length) {
            throw new DERDecodeException("offset out of range");
        }
        this.tag = data[offset];
        if (this.tag == -1) {
            throw new DERDecodeException("no data to read");
        }
        this.readContentLength(data, offset + 1);
        if (data.length < this.contentOffset + this.contentLength) {
            throw new DERDecodeException("bytes error");
        }
        this.length = this.contentOffset - offset + this.contentLength;
    }

    public int getLength() {
        return this.length;
    }

    public boolean isConstructed() {
        return (this.tag & 0x20) != 0;
    }

    public int getTag() {
        return this.tag;
    }

    public int getContentOffset() {
        return this.contentOffset;
    }

    public int getContentLength() {
        return this.contentLength;
    }

    protected void readContentLength(byte[] data, int offset) throws DERDecodeException {
        this.contentLength = data[offset];
        this.contentOffset = offset + 1;
        if (this.contentLength == 128) {
            throw new DERDecodeException("indefinite-length encoding");
        }
        if (this.contentLength < 0) {
            int size = this.contentLength & 0x7F;
            this.contentOffset += size;
            if (this.contentOffset >= data.length) {
                throw new DERDecodeException("EOF found reading length");
            }
            this.contentLength = 0;
            int i = 0;
            int j = offset + 1;
            while (i < size) {
                int next = data[j] & 0xFF;
                this.contentLength = (this.contentLength << 8) + next;
                ++i;
                ++j;
            }
        }
    }
}

