/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.ocsp;

import cn.com.infosec.asn1.ASN1InputStream;
import cn.com.infosec.asn1.DEROctetString;
import cn.com.infosec.asn1.ocsp.ResponderID;
import cn.com.infosec.asn1.x509.SubjectPublicKeyInfo;
import cn.com.infosec.jce.X509Principal;
import cn.com.infosec.ocsp.OCSPException;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.PublicKey;
import javax.security.auth.x500.X500Principal;

public class RespID {
    ResponderID id;

    public RespID(ResponderID id) {
        this.id = id;
    }

    public RespID(X500Principal name) {
        try {
            this.id = new ResponderID(new X509Principal(name.getEncoded()));
        }
        catch (IOException e) {
            throw new IllegalArgumentException("can't decode name.");
        }
    }

    public RespID(PublicKey key) throws OCSPException {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA1");
            ASN1InputStream aIn = new ASN1InputStream(key.getEncoded());
            SubjectPublicKeyInfo info = SubjectPublicKeyInfo.getInstance(aIn.readObject());
            digest.update(info.getPublicKeyData().getBytes());
            DEROctetString keyHash = new DEROctetString(digest.digest());
            this.id = new ResponderID(keyHash);
        }
        catch (Exception e) {
            throw new OCSPException("problem creating ID: " + e, e);
        }
    }

    public ResponderID toASN1Object() {
        return this.id;
    }

    public boolean equals(Object o) {
        if (!(o instanceof RespID)) {
            return false;
        }
        RespID obj = (RespID)o;
        return this.id.equals(obj.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }
}

