package com.clx.performance.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.clx.performance.param.pc.OrderGoodsEditParams;
import com.clx.performance.param.pc.PageOrderGoodsListParam;
import com.clx.performance.model.OrderGoods;
import com.clx.performance.sqlProvider.OrderGoodsSqlProvider;
import com.clx.performance.vo.app.OrderGoodsAPPVO;
import com.clx.performance.vo.pc.OrderGoodsVO;
import org.apache.ibatis.annotations.*;

import java.math.BigDecimal;
import java.util.List;

/**
 * @author kavin
 * Date 2023-09-17
 * Time 16:45
 */
public interface OrderGoodsMapper extends BaseMapper<OrderGoods> {

    @Update(" update order_goods set " +
            " residue_transport_weight = residue_transport_weight-#{weight} " +
            " where id = #{orderId}")
    int updateWeight(@Param("orderId") Integer orderId, @Param("weight") BigDecimal weight);

    @SelectProvider(type = OrderGoodsSqlProvider.class, method = "getMaxOrderGoodsId")
    String getMaxOrderGoodsId();

    @SelectProvider(type = OrderGoodsSqlProvider.class, method = "pageOrderGoodsList")
    IPage<OrderGoodsVO> pageOrderGoodsList(@Param("page") Page<OrderGoodsVO> page, @Param("param") PageOrderGoodsListParam param);

    @Update(" update order_goods set " +
            " residue_transport_weight = residue_transport_weight-#{weight}," +
            " already_transport_weight = already_transport_weight+#{weight}," +
            "order_goods_status = #{orderGoodsStatus} " +
            " where id = #{id}")
    void updateOrderGoodsWeightAndStatus(@Param("id") Integer id, @Param("weight") BigDecimal orderChildWeight, @Param("orderGoodsStatus") Integer orderGoodsStatus);

    @Update(" update order_goods set " +
            " residue_transport_weight = residue_transport_weight-#{residueTransportWeight}," +
            " already_transport_weight = already_transport_weight+#{alreadyTransportWeight}," +
            "order_goods_status = #{orderGoodsStatus} " +
            " where id = #{id}")
    void updateOrderGoodsWeightResidueAndAlreadyAndStatus(@Param("id") Integer id, @Param("alreadyTransportWeight") BigDecimal alreadyTransportWeight, @Param("residueTransportWeight") BigDecimal residueTransportWeight,@Param("orderGoodsStatus") Integer orderGoodsStatus);


    @SelectProvider(type = OrderGoodsSqlProvider.class, method = "openOrderPageGoodsList")
    IPage<OrderGoodsAPPVO> openOrderPageGoodsList(Page<OrderGoodsAPPVO> page);

    @SelectProvider(type = OrderGoodsSqlProvider.class, method = "exclusiveOrderPageGoodsList")
    IPage<OrderGoodsAPPVO> exclusiveOrderPageGoodsList(Page<OrderGoodsAPPVO> page, List<String> param);

    @Update(" update order_goods set " +
            " order_goods_status = #{code} " +
            " where order_goods_no = #{orderGoodsNo}")
    void updateOrderGoodsStatusByOrderGoodsNo(@Param("orderGoodsNo") String orderGoodsNo, @Param("code") Integer code);

    @SelectProvider(type = OrderGoodsSqlProvider.class, method = "saveBatchEntity")
    void saveBatchEntity(List<OrderGoods> orderGoodsList);

    @UpdateProvider(type = OrderGoodsSqlProvider.class, method = "updateOrderGoodsSetResidueWeightAndAlreadyWeight")
    Integer updateOrderGoodsSetResidueWeightAndAlreadyWeight(@Param(value = "residueWeight") BigDecimal residueWeight, @Param(value = "alreadyWeight") BigDecimal alreadyWeight,@Param(value = "id") Integer id);

    @UpdateProvider(type = OrderGoodsSqlProvider.class, method = "updateOrderGoodsSetAlreadyWeight")
    Integer updateOrderGoodsSetAlreadyWeight(@Param(value = "alreadyWeight") BigDecimal alreadyWeight,@Param(value = "id") Integer id);

    @SelectProvider(type = OrderGoodsSqlProvider.class, method = "findOrderGoodsById")
    OrderGoodsVO findOrderGoodsById(Integer id);

    @UpdateProvider(type = OrderGoodsSqlProvider.class, method = "updateOrderGoods")
    Integer updateOrderGoods(@Param(value = "params") OrderGoodsEditParams orderGoodsEditParams);

    @UpdateProvider(type = OrderGoodsSqlProvider.class, method = "updateOrderGoodsSetResidueWeightAndAlreadyWeightAndStatus")
    Integer updateOrderGoodsSetResidueWeightAndAlreadyWeightAndStatus(@Param(value = "residueWeight") BigDecimal residueWeight,@Param(value = "alreadyWeight") BigDecimal alreadyWeight,@Param(value = "status") Integer status,@Param(value = "id") Integer id);

    @SelectProvider(type = OrderGoodsSqlProvider.class, method = "getAlreadyTransportWeight")
    BigDecimal getAlreadyTransportWeight(@Param("orderNo") String orderNo);
    List<OrderGoodsAPPVO> getCancelOrderGoods(@Param(value = "param") List<String> param);

    @Select("select sum(already_transport_weight) from order_goods where order_no=#{orderNo}")
    BigDecimal sumAlreadyTransportWeightByOrderNo(@Param("orderNo")String orderNo);

    @Select("select pending_order_freight from order_goods where " +
            " send_address_id = #{sendAddressId} and" +
            " receive_address_id = #{receiveAddressId}  order by id desc limit 10 ")
    List<Double> getFreightPrice(@Param("sendAddressId") Integer sendAddressId,
                                                  @Param("receiveAddressId") Integer receiveAddressId);

}
