package com.clx.performance.listener;

import com.alibaba.fastjson.JSON;
import com.clx.open.sdk.callback.OpenCallBackClient;
import com.clx.open.sdk.callback.message.OrderChildMessage;
import com.clx.open.sdk.enums.ResultStatusEnum;
import com.clx.order.enums.SyncPlatformEnum;
import com.clx.order.feign.OrderFeign;
import com.clx.order.vo.feign.FeignOrderVO;
import com.clx.performance.config.MslAppConfig;
import com.clx.performance.constant.RabbitKeyConstants;
import com.clx.performance.dto.dts.DataTransportDTO;
import com.clx.performance.enums.DtsOperationTypeEnum;
import com.clx.performance.enums.OrderChildEnum;
import com.clx.performance.model.OrderChild;
import com.clx.performance.service.LastTruckService;
import com.clx.performance.struct.OrderChildStruct;
import com.msl.common.result.Result;
import com.msl.common.utils.DtsMapConvertUtil;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Objects;
import java.util.Optional;

@Slf4j
@Component
@AllArgsConstructor
public class OrderChildDtsListener  {
    @Autowired
    private final MslAppConfig mslAppConfig;


    @Autowired
    private OrderFeign orderFeign;

    @Autowired
    LastTruckService lastTruckService;
    @Autowired
    OrderChildStruct orderChildStruct;


    @RabbitListener(queues = RabbitKeyConstants.CLX_PERFORMANCE_ORDER_CHILD_QUEUE)
    public void onMessage(Message message) {
        try {
            String msg = new String(message.getBody());
            log.info("DTS消息同步开始, database:clx_performance.order_child, msg:{}", msg);
            DataTransportDTO dataTransportDTO = JSON.parseObject(msg, DataTransportDTO.class);
            log.info("DTS消息同步开始, database:clx_performance.order_child, 实体:{}", dataTransportDTO);
            log.info("操作类型：{}",dataTransportDTO.getOperationType().getCode());
            OrderChildMessage before = DtsMapConvertUtil.convert(dataTransportDTO.getBeforeMap(), new OrderChildMessage());
            OrderChildMessage after = DtsMapConvertUtil.convert(dataTransportDTO.getAfterMap(), new OrderChildMessage());

            if(Objects.equals(DtsOperationTypeEnum.INSERT.getCode(),dataTransportDTO.getOperationType().getCode())){
                //同步after数据
                log.info("新增:{}"+after);
                if(OrderChildEnum.SYNC_STATUS_lIST.contains(after.getStatus()) && !Objects.equals(before.getStatus(),after.getStatus())){
                    orderChildChangeAfter(after);
                }
            }else if(Objects.equals(DtsOperationTypeEnum.UPDATE.getCode(),dataTransportDTO.getOperationType().getCode())){
                log.info("修改:{}"+after);
                if(OrderChildEnum.SYNC_STATUS_lIST.contains(after.getStatus()) && !Objects.equals(before.getStatus(),after.getStatus())){
                    orderChildChangeAfter(after);
                }
            }else if(Objects.equals(DtsOperationTypeEnum.DELETE.getCode(),dataTransportDTO.getOperationType().getCode())){
                //数据删除
                log.info("删除:{}"+before);

            }
        } catch (Exception e) {
            log.info("DTS消息同步失败, database:clx_performance.order_child, error:{}", e.getMessage());
        }
    }

    public void orderChildChangeAfter(OrderChildMessage after){
        FeignOrderVO orderInfoFeign = orderFeign.getOrderInfoFeign(after.getOrderNo());
        if (orderInfoFeign == null) {
            return;
        }
        //同步交易平台的运单
        if(Objects.equals(orderInfoFeign.getOrderSource(), SyncPlatformEnum.TRADE_PLATFORM.getCode())){
            //同步after数据
            Optional<OrderChildEnum.Status> option = OrderChildEnum.Status.getByCode(after.getStatus());
            String statusName = option.isPresent()?option.get().getName():"未知状态";
            log.info("同步运单数据，运单号:{},运单状态:{}",after.getChildNo(),statusName);
            //如果订单是取消操作，同步给交易平台统一 10000 的code
            if(OrderChildEnum.DTS_LISTEN_CANCEL_lIST.contains(after.getStatus())){
                after.setStatus(com.clx.open.sdk.enums.OrderChildEnum.Status.COMMON_CANCEL.getCode());
            }
            after.setLastFlag(ResultStatusEnum.NO.getCode());
            OpenCallBackClient client = new OpenCallBackClient(mslAppConfig.getUrl(),mslAppConfig.getAppId(),mslAppConfig.getSecret());
            Result<?> result = client.encryptPost(JSON.toJSONString(after),after.topic());
            log.info("运单信息同步，运单编号:{},响应结果:{}",after.getChildNo(),JSON.toJSONString(result));
            //当运单状态为到达目的地之后的状态时候，需要判断最后一车的逻辑
            if(after.getStatus() >= OrderChildEnum.Status.ARRIVE_RECEIVE.getCode()  && after.getStatus() <= OrderChildEnum.Status.COMPLETE.getCode()){
                OrderChild child = lastTruckService.getLastTruckChild(after.getOrderNo());
                if(Objects.nonNull(child)){
                    OrderChildMessage message = orderChildStruct.convertMessage(child);
                    message.setLastFlag(ResultStatusEnum.YES.getCode());
                    log.info("开始同步最后一车的运单，运单编号:{},运单信息:{}",child.getChildNo(),JSON.toJSONString(message));
                    OpenCallBackClient client2 = new OpenCallBackClient(mslAppConfig.getUrl(),mslAppConfig.getAppId(),mslAppConfig.getSecret());
                    Result<?> result2 = client2.encryptPost(JSON.toJSONString(message),message.topic());
                    log.info("结束同步最后一车的运单，运单编号:{}，响应结果:{}",child.getChildNo(),JSON.toJSONString(result2));

                }
            }
        }
    }

}
