package com.clx.performance.enums.integral;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.List;

public enum IntegralRecordEnum {
    ;

    @Getter
    @AllArgsConstructor
    public enum Type{
        SYSTEM(1, "系统"),
        PROTECTION(2, "保护分"),
        PROTECTION_CANCEL(3, "保护分取消"),
        SETTLEMENT(4, "结算分"),
        BASE(5, "基础分"),

        ORDER_CHILD_COMPLETE(11, "运单完成"),
        ORDER_CHILD_COMPLETE_NUM(12, "运单完成数量"),
        ORDER_CHILD_COMPLETE_WATER(13, "流水单"),
        ORDER_CHILD_COMPLETE_SUPPORT(14, "支援单"),

        ORDER_CHILD_CANCEL(21, "运单取消"),
        ORDER_CHILD_ARRIVE_SEND_ADDRESS_TIMEOUT_CANCEL(22, "超时未到达货源地"),
        ORDER_CHILD_ARRIVE_RECEIVE_ADDRESS_TIMEOUT(23, "超时到达目的地"),

        ORDER_CHILD_PLATFORM_CANCEL(24, "平台取消补偿"),
        ORDER_CHILD_PLATFORM_COMPENSATION(25, "平台补偿"),


        REPORT_TRUCK_INFO(50, "提交基础信息"),
        REPORT_REFUEL(51, "油表上报"),
        REPORT_TRAFFIC(52, "上报交通拥堵"),
        REPORT_SEND_ADDRESS_WAIT(53, "上报货源地需要排队"),
        REPORT_SEND_ADDRESS_NO_WAIT(54, "上报货源地无需排队"),
        REPORT_RECEIVE_ADDRESS_WAIT(55, "上报目的地需要排队"),
        REPORT_RECEIVE_ADDRESS_NO_WAIT(56, "上报目的地无需排队"),
        REPORT_QUALITY(57, "上报煤炭质量问题"),
        REPORT_ABNORMAL(58, "上报拉运异常问题"),
        REPORT_SEND_ADDRESS_INFO(59, "上报货源地情况"),
        ;

        private Integer value;
        private String msg;
    }

    // 取消
    public static final List<Integer> DRIVER_REPORT_lIST = Arrays.asList(
            Type.REPORT_TRUCK_INFO.value,
            Type.REPORT_REFUEL.value,
            Type.REPORT_TRAFFIC.value,
            Type.REPORT_SEND_ADDRESS_WAIT.value,
            Type.REPORT_SEND_ADDRESS_NO_WAIT.value,
            Type.REPORT_RECEIVE_ADDRESS_WAIT.value,
            Type.REPORT_RECEIVE_ADDRESS_NO_WAIT.value,
            Type.REPORT_QUALITY.value,
            Type.REPORT_ABNORMAL.value

    );
    // 取消
    public static final List<Integer> PLATFORM_CANCEL_lIST = Arrays.asList(
            Type.REPORT_TRUCK_INFO.value,
            Type.REPORT_REFUEL.value,
            Type.REPORT_TRAFFIC.value,
            Type.REPORT_SEND_ADDRESS_WAIT.value,
            Type.REPORT_SEND_ADDRESS_NO_WAIT.value,
            Type.REPORT_RECEIVE_ADDRESS_WAIT.value,
            Type.REPORT_RECEIVE_ADDRESS_NO_WAIT.value,
            Type.REPORT_QUALITY.value,
            Type.REPORT_ABNORMAL.value

    );

}
