package com.clx.performance.sqlProvider.linewarn;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.clx.performance.param.pc.linewarn.PageLineWarnConfigParam;
import org.apache.commons.lang.StringUtils;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.jdbc.SQL;

import java.util.Objects;

public class LineWarnConfigSqlProvider {

    private static final String TABLE = "line_warn_config";
    public String pageByParam(@Param("page") Page page, @Param("param") PageLineWarnConfigParam param) {

        return new SQL(){{

            SELECT("*");
            FROM(TABLE);
            WHERE("delete_status = 0");
            if (StringUtils.isNotBlank(param.getWarnName())) {WHERE("warn_name like CONCAT('%', #{param.warnName},'%')");}
            if (Objects.nonNull(param.getWarnType())) {WHERE("warn_type = #{param.warnType}");}
            if (Objects.nonNull(param.getWarnLevel())) {WHERE("warn_level = #{param.warnLevel}");}
            if (Objects.nonNull(param.getStatus())) {WHERE("status = #{param.status}");}

            if (StringUtils.isNotBlank(param.getBeginTime())) {WHERE("create_time >= #{param.beginTime}");}
            if (StringUtils.isNotBlank(param.getEndTime())) {WHERE("create_time <= #{param.endTime}");}

            ORDER_BY("id desc");
        }}.toString();
    }

}
