package com.clx.performance.service.impl.settle;

import com.clx.performance.param.pc.owner.PageOwnerSettlementParam;
import com.clx.performance.service.settle.SettlementOwnerExportService;
import com.clx.performance.service.settle.SettlementOwnerService;
import com.clx.performance.utils.excel.ExcelData;
import com.clx.performance.utils.excel.ExcelField;
import com.clx.performance.utils.excel.ExcelSheet;
import com.clx.performance.utils.excel.ExcelUtil;
import com.clx.performance.vo.pc.owner.settle.OwnerPageSettlementOwnerVO;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;

@Slf4j
@Service
public class SettlementOwnerExportServiceImpl implements SettlementOwnerExportService {

    @Autowired
    private SettlementOwnerService settlementOwnerService;
    @Override
    public void exportSettlementOwner(PageOwnerSettlementParam param) {
        param.setPage(1);
        param.setPageSize(1000000);
        List<OwnerPageSettlementOwnerVO> list = settlementOwnerService.pageSettlementOwner(param).getRecords();

        // 组装表头
        List<ExcelField> fieldList = new ArrayList<>();
        fieldList.add(new ExcelField(0, "序号", "index", 2000));
        fieldList.add(new ExcelField(1, "结算单号", "settlementNo", 5000));
        fieldList.add(new ExcelField(2, "订单编号", "orderNo", 5000));
        fieldList.add(new ExcelField(3, "开票标识", "invoiceType", 5000));
        fieldList.add(new ExcelField(4, "公司编码", "ownerUserNo", 5000));

        fieldList.add(new ExcelField(5, "结算方式", "settlementWay", 5000));
        fieldList.add(new ExcelField(6, "装车净重", "loadNet", 5000));
        fieldList.add(new ExcelField(7, "卸车净重", "unloadNet", 5000));
        fieldList.add(new ExcelField(8, "实际净重（吨）", "weight", 5000));
        fieldList.add(new ExcelField(9, "应付运费", "freight", 5000));

        fieldList.add(new ExcelField(10, "预付运费金额", "prepayFreight", 5000));
        fieldList.add(new ExcelField(11, "货损吨数", "lossWeight", 5000));
        fieldList.add(new ExcelField(12, "货损金额", "lossFreight", 5000));
        fieldList.add(new ExcelField(13, "管理费", "invoiceServiceFee", 5000));
        fieldList.add(new ExcelField(14, "借款抵扣金额", "loanFreight", 5000));

        fieldList.add(new ExcelField(15, "结算金额", "settlementFreight", 5000));
        fieldList.add(new ExcelField(16, "开票金额", "invoiceFreight", 5000));
        fieldList.add(new ExcelField(17, "开票公司", "invoicingCompanyShorterName", 5000));
        fieldList.add(new ExcelField(18, "创建时间", "createTime", 5000));
        fieldList.add(new ExcelField(19, "状态", "status", 5000));

        // 组装数据
        List<List<ExcelData>> dataList = new ArrayList<>();
        for (int i=0; i<list.size(); i++){

            OwnerPageSettlementOwnerVO dto = list.get(i);
            List<ExcelData> rowData = new ArrayList<>();

            rowData.add(new ExcelData(i+1));
            rowData.add(new ExcelData(dto.getSettlementNo()));
            rowData.add(new ExcelData(dto.getOrderNo()));
            rowData.add(new ExcelData(dto.getInvoiceTypeMsg()));
            rowData.add(new ExcelData(dto.getOwnerUserNo().toString()));

            rowData.add(new ExcelData(dto.getSettlementWayMsg()));
            rowData.add(new ExcelData(dto.getLoadNet()));
            rowData.add(new ExcelData(dto.getUnloadNet()));
            rowData.add(new ExcelData(dto.getWeight()));
            rowData.add(new ExcelData(dto.getFreight().movePointLeft(2).setScale(2, RoundingMode.HALF_UP)));

            rowData.add(new ExcelData(dto.getPrepayFreight().movePointLeft(2).setScale(2, RoundingMode.HALF_UP)));
            rowData.add(new ExcelData(dto.getLossWeight()));
            rowData.add(new ExcelData(dto.getLossFreight().movePointLeft(2).setScale(2, RoundingMode.HALF_UP)));
            rowData.add(new ExcelData(dto.getInvoiceServiceFee().movePointLeft(2).setScale(2, RoundingMode.HALF_UP)));
            rowData.add(new ExcelData(dto.getLoanFreight().movePointLeft(2).setScale(2, RoundingMode.HALF_UP)));

            rowData.add(new ExcelData(dto.getSettlementFreight().movePointLeft(2).setScale(2, RoundingMode.HALF_UP)));
            rowData.add(new ExcelData(dto.getInvoiceFreight().movePointLeft(2).setScale(2, RoundingMode.HALF_UP)));
            rowData.add(new ExcelData(dto.getInvoicingCompanyShorterName()));
            rowData.add(new ExcelData(dto.getCreateTime()));
            rowData.add(new ExcelData(dto.getStatusMsg()));

            dataList.add(rowData);
        }

        ExcelSheet excelSheet = new ExcelSheet("货主结算单", "货主结算单", fieldList, dataList);

        // 导出
        ExcelUtil.export(excelSheet);
    }
}
