package com.clx.performance.service.impl;

import cn.hutool.json.JSONUtil;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.clx.performance.dao.OwnerRunningWaterRecordDao;
import com.clx.performance.enums.OwnerAccountEnum;
import com.clx.performance.param.pc.PageOwnerAccountRunningWaterParam;
import com.clx.performance.service.OwnerRunningWaterRecordService;
import com.clx.performance.utils.excel.ExcelData;
import com.clx.performance.utils.excel.ExcelField;
import com.clx.performance.utils.excel.ExcelSheet;
import com.clx.performance.utils.excel.ExcelUtil;
import com.clx.performance.vo.pc.OwnerAccountRunningWaterRecordVO;
import com.msl.user.data.UserSessionData;
import com.msl.user.utils.TokenUtil;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

@Slf4j
@Service
@AllArgsConstructor
public class OwnerRunningWaterRecordServiceImpl implements OwnerRunningWaterRecordService {

    private final OwnerRunningWaterRecordDao ownerRunningWaterRecordDao;

    @Override
    public IPage<OwnerAccountRunningWaterRecordVO> ownerAccountRunningWaterPageList(PageOwnerAccountRunningWaterParam param) {
        UserSessionData loginUserInfo = TokenUtil.getLoginUserInfo();
        param.setOwnerUserNo(loginUserInfo.getCompanyNo());
        return ownerRunningWaterRecordDao.ownerAccountRunningWaterPageList(param);
    }

    @Override
    public SXSSFWorkbook exportOwnerAccountRunningWaterPageList(PageOwnerAccountRunningWaterParam param) {
        UserSessionData loginUserInfo = TokenUtil.getLoginUserInfo();
        param.setOwnerUserNo(loginUserInfo.getCompanyNo());
        List<OwnerAccountRunningWaterRecordVO> list = ownerRunningWaterRecordDao.ownerAccountRunningWaterList(param);
        // 组装表头
        List<ExcelField> fieldList = new ArrayList<>();
        fieldList.add(new ExcelField(0, "序号", "index", 2000));
        fieldList.add(new ExcelField(1, "公司编码", "ownerUserNo", 5000));
        fieldList.add(new ExcelField(2, "公司名称", "ownerName", 5000));
        fieldList.add(new ExcelField(3, "联系电话", "mobile", 5000));
        fieldList.add(new ExcelField(4, "账户类型", "accountType", 15000));
        fieldList.add(new ExcelField(5, "流水类型", "runningWaterType", 5000));
        fieldList.add(new ExcelField(6, "订单编号", "orderNo", 5000));
        fieldList.add(new ExcelField(7, "运单编号", "orderChildNo", 5000));

        fieldList.add(new ExcelField(8, "变动金额", "alterationBalance", 5000));
        fieldList.add(new ExcelField(9, "冻结金额", "frozenBalance", 5000));
        fieldList.add(new ExcelField(10, "可用余额", "usableBalance", 5000));
        fieldList.add(new ExcelField(11, "账户余额", "accountBalance", 5000));
        fieldList.add(new ExcelField(12, "扣除金额", "takeOutBalance", 5000));
        fieldList.add(new ExcelField(13, "流水编号", "runningWaterNo", 5000));
        fieldList.add(new ExcelField(14, "操作人", "createBy", 5000));
        fieldList.add(new ExcelField(15, "操作时间", "createTime", 5000));


        // 组装数据
        List<List<ExcelData>> dataList = new ArrayList<>();
        for (int i=0; i<list.size(); i++){

            OwnerAccountRunningWaterRecordVO dto = list.get(i);
            List<ExcelData> rowData = new ArrayList<>();

            rowData.add(new ExcelData(i+1));
            rowData.add(new ExcelData(dto.getOwnerUserNo().toString()));
            rowData.add(new ExcelData(dto.getOwnerUserName()));
            rowData.add(new ExcelData(dto.getMobile()));
            rowData.add(new ExcelData(OwnerAccountEnum.AccountTypeStatus.getByCode(dto.getAccountType()).get().getMsg()));
            rowData.add(new ExcelData(OwnerAccountEnum.RunningWaterStatus.getByCode(dto.getRunningWaterType()).get().getMsg()));
            rowData.add(new ExcelData(dto.getOrderNo()));
            rowData.add(new ExcelData(dto.getOrderChildNo()));
            rowData.add(new ExcelData(dto.getAlterationBalance() == null ? null : dto.getAlterationBalance().movePointLeft(2)));
            rowData.add(new ExcelData(dto.getFrozenBalance() == null ? null : dto.getFrozenBalance().movePointLeft(2)));
            rowData.add(new ExcelData(dto.getUsableBalance() == null ? null : dto.getUsableBalance().movePointLeft(2)));
            rowData.add(new ExcelData(dto.getAccountBalance() == null ? null : dto.getAccountBalance().movePointLeft(2)));
            rowData.add(new ExcelData(dto.getTakeOutBalance() == null ? null : dto.getTakeOutBalance().movePointLeft(2)));
            rowData.add(new ExcelData(dto.getRunningWaterNo() == null ? "" : dto.getRunningWaterNo().toString()));
            rowData.add(new ExcelData(dto.getCreateBy()));
            rowData.add(new ExcelData(dto.getCreateTime()));

            dataList.add(rowData);
        }
        ExcelSheet excelSheet = new ExcelSheet("货主资金账户管理", "货主资金账户管理", fieldList, dataList);

        //创建excel
        return ExcelUtil.create(excelSheet);
    }
}
