package com.clx.performance.vo.pc.broker;

import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

@Getter
@Setter
@ToString
@NoArgsConstructor
public class TransportVO {

    @ApiModelProperty(value = "源运单编号", example = "1234", required = true, dataType = "String")
    private String sourceChildNo;
    @ApiModelProperty(value = "运单编号", example = "1234", required = true, dataType = "String")
    private String childNo;

    @ApiModelProperty(value = "风控状态 0-正常，1-单项异常，2-多项异常", example = "1", dataType = "Integer")
    private Integer riskStatus;
    @ApiModelProperty(value = "风控异常原因", example = "1", dataType = "String")
    private String riskReason;

    @ApiModelProperty(value = "同步状态 0-未同步，1-已同步，2-同步失败", example = "1", dataType = "Integer")
    private Integer syncStatus;
    @ApiModelProperty(value = "同步失败原因", example = "1", dataType = "String")
    private String syncMsg;

    @ApiModelProperty(value = "结算状态 0 未结算 1 已结算 2结算中 3结算失败 ", example = "1234124", dataType = "String")
    private Integer settleStatus;
    @ApiModelProperty(value = "结算方", example = "1", dataType = "String")
    private Integer settleOrg;
    @ApiModelProperty(value = "结算失败原因", example = "1", dataType = "String")
    private String settleMsg;

    @ApiModelProperty(value = "开票状态 0 未开票 1 已开票 ", example = "1234124", dataType = "String")
    private Integer invoiceStatus;

    @ApiModelProperty(value = "第三方运单状态 20-已卸货，30-已创建支付单", example = "1234124", dataType = "String")
    private Integer thirdPartyChildStatus;

}
