package com.clx.performance.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.msl.common.config.KeyColumn;
import com.msl.common.model.HasKey;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * @author kavin
 * Date 2024-07-12
 * Time 16:02
 */
@Getter
@Setter
@Accessors(chain = true)
@TableName("performance_progress")
public class PerformanceProgress implements HasKey<Integer> {

    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    @TableField("seq")
    @ApiModelProperty("排序")
    private Long seq;

    @TableField("order_no")
    @ApiModelProperty("订单编号")
    private String orderNo;

    @TableField("order_status")
    @ApiModelProperty("订单状态： 0待报价 1客户确认中 2报价已确认 3平台已承接 4已取消 5暂停 6拒绝承运 7 挂单中 8运输中 9订单已完成 10 已失效")
    private Integer orderStatus;

    @TableField("send_address_id")
    @ApiModelProperty("发货-地址id")
    private Integer sendAddressId;

    @TableField("send_address_shorter")
    @ApiModelProperty("货源地简称")
    private String sendAddressShorter;

    @TableField("send_system_address_id")
    @ApiModelProperty("货源地-标准地址id")
    private Integer sendSystemAddressId;

    @TableField("send_system_address_shorter")
    @ApiModelProperty("货源地-标准地址简称")
    private String sendSystemAddressShorter;

    @TableField("senior_logistics_manager_name")
    @ApiModelProperty("高级物流经理姓名数组")
    private String seniorLogisticsManagerName;

    @TableField("goods_type_code")
    @ApiModelProperty("货物类型编码")
    private String goodsTypeCode;

    @TableField("goods_type_name")
    @ApiModelProperty("货物类型名称")
    private String goodsTypeName;

    @TableField("goods_name_id")
    @ApiModelProperty("货物名称id")
    private Integer goodsNameId;

    @TableField("goods_name")
    @ApiModelProperty("货物名称")
    private String goodsName;

    @TableField("send_address")
    @ApiModelProperty("煤源位置")
    private String sendAddress;

    @TableField("send_over_standard")
    @ApiModelProperty("是否C类煤源  0 否  1 是")
    private Integer sendOverStandard;

    @TableField("driver_freight_price")
    @ApiModelProperty("司机运费")
    private BigDecimal driverFreightPrice;

    @TableField("task_weight")
    @ApiModelProperty("任务吨数")
    private BigDecimal taskWeight;


    @TableField("pending_weight")
    @ApiModelProperty("挂单吨数")
    private BigDecimal pendingWeight;


    @TableField("pending_truck")
    @ApiModelProperty("挂单车数")
    private Integer pendingTruck;


    @TableField("ordered_truck_num")
    @ApiModelProperty("接单车数")
    private Integer orderedTruckNum;


    @TableField("ordered_weight")
    @ApiModelProperty("接单吨数")
    private BigDecimal orderedWeight;

    @TableField("arrive_send_truck_num")
    @ApiModelProperty("到达货源地车数")
    private Integer arriveSendTruckNum;

    @TableField("load_truck_num")
    @ApiModelProperty("装车车数")
    private Integer loadTruckNum;

    @TableField("unload_truck_num")
    @ApiModelProperty("卸车车数")
    private Integer unloadTruckNum;

    @TableField("on_the_way_truck_num")
    @ApiModelProperty("在途车数")
    private Integer onTheWayTruckNum;

    @TableField("sum_load_weight")
    @ApiModelProperty("矿发吨数")
    private BigDecimal sumLoadWeight;

    @TableField("sum_unload_weight")
    @ApiModelProperty("到站吨数")
    private BigDecimal sumUnloadWeight;

    @TableField("sum_on_the_way_weight")
    @ApiModelProperty("在途吨数")
    private BigDecimal sumOnTheWayWeight;

    @TableField("today_expect_complete")
    @ApiModelProperty("今日预计完成吨数")
    private BigDecimal todayExpectComplete;

    @TableField("abnormal_remark")
    @ApiModelProperty("异常备注")
    private String abnormalRemark;

    @TableField("performance_abnormal_reason")
    @ApiModelProperty("履约异常原因")
    private String performanceAbnormalReason;

    @TableField("dispatch_follow")
    @ApiModelProperty("调度备注/跟进措施")
    private String dispatchFollow;

    @TableField("order_distance")
    @ApiModelProperty("重车运距(公里)")
    private BigDecimal orderDistance;

    @TableField("transport_time_slot")
    @ApiModelProperty("可拉运时间段")
    private String transportTimeSlot;

    @TableField("pending_time")
    @ApiModelProperty("挂单时间")
    private LocalDateTime pendingTime;

    @TableField("trade_require_arrive_station_time")
    @ApiModelProperty("交易要求到站时间")
    private String tradeRequireArriveStationTime;

    @TableField("transport_expect_arrive_station_time")
    @ApiModelProperty("物流预计到站时间")
    private String transportExpectArriveStationTime;

    @TableField("prediction_freight_price")
    @ApiModelProperty("测算运费")
    private BigDecimal predictionFreightPrice;

    @TableField("create_time")
    @ApiModelProperty("创建时间")
    private LocalDateTime createTime;

    @TableField("modified_time")
    @ApiModelProperty("修改时间")
    private LocalDateTime modifiedTime;

    @Override
    @KeyColumn("id")
    public Integer gainKey() {
    return this.id;
    }
}
