package com.clx.performance.dto.zjxl;

import com.clx.performance.utils.LocalDateTimeUtils;
import com.clx.performance.utils.zjxl.ZJXLPositionUtils;

import java.math.BigDecimal;

/**
 * @ClassName TruckLocationDTO
 * @Description
 * @Author kavin
 * @Date 2023/9/18 13:13
 * @Version 1.0
 */
public class TruckLocationDTO {

    private String truckNo;
    private BigDecimal angle;
    private BigDecimal speed;
    private BigDecimal[] location;
    private String gpsTime;
    private String province;
    private String city;
    private String country;
    private String address;
    private String createTime;
    private String modifiedTime;

    public TruckLocationDTO(String angle, String speed, String lon, String lat, String gpsTime, String province, String city, String country, String address) {
        this.angle = new BigDecimal(angle);
        this.speed = ZJXLPositionUtils.speedFormat(speed);
        this.location = ZJXLPositionUtils.WGS484Format(lon, lat);
        this.gpsTime = LocalDateTimeUtils.getFormatByLong(Long.parseLong(gpsTime), (String)null);
        this.province = province;
        this.city = city;
        this.country = country;
        this.address = address;
    }


    public String getTruckNo() {
        return truckNo;
    }

    public void setTruckNo(String truckNo) {
        this.truckNo = truckNo;
    }

    public BigDecimal getAngle() {
        return angle;
    }

    public void setAngle(BigDecimal angle) {
        this.angle = angle;
    }

    public BigDecimal getSpeed() {
        return speed;
    }

    public void setSpeed(BigDecimal speed) {
        this.speed = speed;
    }

    public BigDecimal[] getLocation() {
        return location;
    }

    public void setLocation(BigDecimal[] location) {
        this.location = location;
    }

    public String getGpsTime() {
        return gpsTime;
    }

    public void setGpsTime(String gpsTime) {
        this.gpsTime = gpsTime;
    }

    public String getProvince() {
        return province;
    }

    public void setProvince(String province) {
        this.province = province;
    }

    public String getCity() {
        return city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public String getCountry() {
        return country;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getCreateTime() {
        return createTime;
    }

    public void setCreateTime(String createTime) {
        this.createTime = createTime;
    }

    public String getModifiedTime() {
        return modifiedTime;
    }

    public void setModifiedTime(String modifiedTime) {
        this.modifiedTime = modifiedTime;
    }
}
