package com.clx.performance;

import cn.hutool.json.JSONObject;
import com.clx.message.feign.ClxMessageOpenapiFeign;
import com.clx.message.req.message.AliSmsMessageReq;
import com.clx.order.feign.OrderFeign;
import com.clx.performance.component.GoodsOrderTruckRecordComponent;
import com.clx.performance.component.OrderGoodsStatusLazyComponent;
import com.clx.performance.config.ClxMessageConfig;
import com.clx.performance.constant.RedisConstants;
import com.clx.performance.dao.LargeScreenAddressRouteDao;
import com.clx.performance.dao.OrderGoodsDao;
import com.clx.performance.service.LargeScreenService;
import com.clx.performance.service.OrderCancelService;
import com.clx.performance.service.OwnerAccountService;
import com.msl.common.result.Result;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.test.context.junit4.SpringRunner;

@SpringBootTest
@RunWith(SpringRunner.class)
public class JobTest {

    @Autowired
    private OrderFeign orderFeign;

    @Autowired
    private RabbitTemplate rabbitTemplate;

    @Autowired
    private StringRedisTemplate stringRedisTemplate;

    @Autowired
    private OrderGoodsStatusLazyComponent orderGoodsStatusLazyComponent;

    @Autowired
    private OrderGoodsDao orderGoodsDao;

    @Autowired
    private GoodsOrderTruckRecordComponent recordComponent;

    @Autowired
    private OrderCancelService orderCancelService;

    @Autowired
    private LargeScreenService largeScreenService;

    @Autowired
    private LargeScreenAddressRouteDao largeScreenAddressRouteDao;

    @Autowired
    private OwnerAccountService ownerAccountService;

    @Autowired
    private ClxMessageOpenapiFeign clxMessageOpenapiFeign;

    @Autowired
    private ClxMessageConfig config;

    @Autowired
    private RedisTemplate<String,String> redisTemplate;

    @Test
    public void test1() {

        AliSmsMessageReq req = new AliSmsMessageReq();
        req.setTemplateCode(config.getCaptchaTemplateCode());
        JSONObject jsonObject = new JSONObject();
        jsonObject.set("code", "222");
        jsonObject.set("time", "12");
        req.setChannelId(41);
        req.setAppId("7134802354519449600");
        req.setMobile("17610126377");
        req.setContent(jsonObject.toString());
        req.setExpire(300L);
        Result<String> stringResult = clxMessageOpenapiFeign.sendAliSms(req);
        System.out.println(stringResult);
        String content = redisTemplate.opsForValue().get(RedisConstants.MESSAGE_MOBILE_CAPTCHA + "17610126377");
        System.out.println(content);
    }
}
