package com.clx.performance.service.impl.settle;

import com.alibaba.fastjson.JSON;
import com.clx.performance.common.MqDelay;
import com.clx.performance.common.MqWrapper;
import com.clx.performance.constant.RabbitKeySettlementConstants;
import com.clx.performance.service.settle.SettlementMqService;
import com.clx.performance.vo.mq.*;
import lombok.extern.slf4j.Slf4j;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessageBuilder;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Slf4j
@Service
public class SettlementMqServiceImpl implements SettlementMqService {

    @Autowired
    private RabbitTemplate rabbitTemplate;

    @Override
    public void settlementDetailAdd(Integer settlementDriverDetailId, Integer settlementOwnerDetailId) {
        SettlementDetailAddMqParam mq = new SettlementDetailAddMqParam();
        mq.setSettlementDriverDetailId(settlementDriverDetailId);
        mq.setSettlementOwnerDetailId(settlementOwnerDetailId);

        MqDelay<MqWrapper<SettlementDetailAddMqParam>> delay =
                new MqDelay<>(RabbitKeySettlementConstants.DEFAULT_EXCHANGE,
                        RabbitKeySettlementConstants.SETTLEMENT_DETAIL_ADD_ROUTING_KEY, new MqWrapper<>(mq));
        Message message = MessageBuilder.withBody(JSON.toJSONString(new MqWrapper<>(delay)).getBytes()).build();
        message.getMessageProperties().setExpiration("5000");
        rabbitTemplate.send(RabbitKeySettlementConstants.DEFAULT_EXCHANGE,
                RabbitKeySettlementConstants.DEFAULT_DELAY_ROUTING_KEY, message);

    }

    @Override
    public void settlementStatistics(String childNo, Integer invoiceType) {

        SettlementStatisticsMqParam mq = new SettlementStatisticsMqParam();
        mq.setChildNo(childNo);
        mq.setInvoiceType(invoiceType);
        log.info("运单号  {} 开票标识 {} ",childNo,invoiceType);
        MqDelay<MqWrapper<SettlementStatisticsMqParam>> delay =
                new MqDelay<>(RabbitKeySettlementConstants.DEFAULT_EXCHANGE,
                        RabbitKeySettlementConstants.SETTLEMENT_DETAIL_INVOICE_TYPE_SYC_ROUTING_KEY, new MqWrapper<>(mq));
        Message message = MessageBuilder.withBody(JSON.toJSONString(new MqWrapper<>(delay)).getBytes()).build();
        message.getMessageProperties().setExpiration("5000");
        rabbitTemplate.send(RabbitKeySettlementConstants.DEFAULT_EXCHANGE,
                RabbitKeySettlementConstants.DEFAULT_DELAY_ROUTING_KEY, message);
    }


    @Override
    public void invoiceTypeSync(String childNo) {

        SettlementInvoiceTypeSyncMqParam mq = new SettlementInvoiceTypeSyncMqParam();
        mq.setChildNo(childNo);
        MqDelay<MqWrapper<SettlementInvoiceTypeSyncMqParam>> delay =
                new MqDelay<>(RabbitKeySettlementConstants.DEFAULT_EXCHANGE,
                        RabbitKeySettlementConstants.SETTLEMENT_INVOICE_TYPE_SYNC_ROUTING_KEY, new MqWrapper<>(mq));
        Message message = MessageBuilder.withBody(JSON.toJSONString(new MqWrapper<>(delay)).getBytes()).build();
        message.getMessageProperties().setExpiration("5000");
        rabbitTemplate.send(RabbitKeySettlementConstants.DEFAULT_EXCHANGE,
                RabbitKeySettlementConstants.DEFAULT_DELAY_ROUTING_KEY, message);
    }

    @Override
    public void settle(String childNo, Integer invoiceType) {

        SettlementSettleMqParam mq = new SettlementSettleMqParam();
        mq.setChildNo(childNo);
        mq.setInvoiceType(invoiceType);
        MqDelay<MqWrapper<SettlementSettleMqParam>> delay = new MqDelay<>(RabbitKeySettlementConstants.DEFAULT_EXCHANGE,
                RabbitKeySettlementConstants.SETTLEMENT_SETTLE_ROUTING_KEY, new MqWrapper<>(mq));
        Message message = MessageBuilder.withBody(JSON.toJSONString(new MqWrapper<>(delay)).getBytes()).build();
        message.getMessageProperties().setExpiration("5000");
        rabbitTemplate.send(RabbitKeySettlementConstants.DEFAULT_EXCHANGE,
                RabbitKeySettlementConstants.DEFAULT_DELAY_ROUTING_KEY, message);
    }

    @Override
    public void invoiceStatusSync(String childNo) {
        SettlementInvoiceStatusSyncMqParam mq = new SettlementInvoiceStatusSyncMqParam();
        mq.setChildNo(childNo);
        MqDelay<MqWrapper<SettlementInvoiceStatusSyncMqParam>> delay = new MqDelay<>(RabbitKeySettlementConstants.DEFAULT_EXCHANGE,
                RabbitKeySettlementConstants.SETTLEMENT_INVOICE_STATUS_SYNC_ROUTING_KEY, new MqWrapper<>(mq));
        Message message = MessageBuilder.withBody(JSON.toJSONString(new MqWrapper<>(delay)).getBytes()).build();
        message.getMessageProperties().setExpiration("5000");
        rabbitTemplate.send(RabbitKeySettlementConstants.DEFAULT_EXCHANGE,
                RabbitKeySettlementConstants.DEFAULT_DELAY_ROUTING_KEY, message);
    }

    @Override
    public void payStatusSync(String childNo) {
        SettlementPayStatusSyncMqParam mq = new SettlementPayStatusSyncMqParam();
        mq.setChildNo(childNo);
        MqDelay<MqWrapper<SettlementPayStatusSyncMqParam>> delay = new MqDelay<>(RabbitKeySettlementConstants.DEFAULT_EXCHANGE,
                RabbitKeySettlementConstants.SETTLEMENT_PAY_STATUS_SYNC_ROUTING_KEY, new MqWrapper<>(mq));
        Message message = MessageBuilder.withBody(JSON.toJSONString(new MqWrapper<>(delay)).getBytes()).build();
        message.getMessageProperties().setExpiration("5000");
        rabbitTemplate.send(RabbitKeySettlementConstants.DEFAULT_EXCHANGE,
                RabbitKeySettlementConstants.DEFAULT_DELAY_ROUTING_KEY, message);
    }

}
