package com.clx.performance.service.impl.broker;

import com.clx.order.feign.AddressFeign;
import com.clx.order.feign.OrderFeign;
import com.clx.order.vo.feign.FeignAddressVO;
import com.clx.order.vo.feign.FeignOrderVO;
import com.clx.order.vo.pc.carrier.InvoicingCompanyVO;
import com.clx.performance.dao.OrderChildImageDao;
import com.clx.performance.dao.settle.SettlementOwnerDetailDao;
import com.clx.performance.enums.PowerTypeEnum;
import com.clx.performance.enums.settle.SettlementOwnerDetailEnum;
import com.clx.performance.extranal.broker.BrokerService;
import com.clx.performance.extranal.order.InvoicingCompanyService;
import com.clx.performance.model.OrderChild;
import com.clx.performance.model.OrderChildImage;
import com.clx.performance.model.OrderGoods;
import com.clx.performance.model.settle.SettlementDriverDetail;
import com.clx.performance.model.settle.SettlementOwnerDetail;
import com.clx.performance.service.broker.OrderChildBrokerService;
import com.clx.performance.vo.pc.broker.*;
import com.clx.user.feign.DocumentFeign;
import com.clx.user.feign.DriverFeign;
import com.clx.user.feign.OwnerFeign;
import com.clx.user.feign.TruckFeign;
import com.clx.user.vo.feign.*;
import com.msl.common.utils.DateUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@Slf4j
@Service
public class OrderChildBrokerServiceImpl implements OrderChildBrokerService {
    private static final String LONG_TERM_TIME = "2099-01-01 00:00:00";

    @Autowired
    private BrokerService brokerService;
    @Autowired
    private OwnerFeign ownerFeign;
    @Autowired
    private OrderFeign orderFeign;
    @Autowired
    private AddressFeign addressFeign;
    @Autowired
    private DriverFeign driverFeign;
    @Autowired
    private DocumentFeign documentFeign;
    @Autowired
    private TruckFeign truckFeign;
    @Autowired
    private OrderChildImageDao orderChildImageDao;
    @Autowired
    private InvoicingCompanyService invoicingCompanyService;
    @Autowired
    private SettlementOwnerDetailDao settlementOwnerDetailDao;


    @Override
    public void orderChildSync(OrderChild orderChild, OrderGoods orderGoods, SettlementOwnerDetail settlementOwnerDetail,
                               SettlementDriverDetail settlementDriverDetail) {

        TransportParam transportParam = buildParam(orderChild, orderGoods, settlementOwnerDetail, settlementDriverDetail);

        // 运单同步
        settlementOwnerDetail.setInvoiceTypeStatus(SettlementOwnerDetailEnum.InvoiceTypeStatus.PROCESSING.getCode());
        settlementOwnerDetailDao.updateInvoiceTypeStatus(settlementOwnerDetail);

        brokerService.orderChildSync(transportParam);
    }

    @Override
    public void orderChildUpdate(OrderChild orderChild, OrderGoods orderGoods, SettlementOwnerDetail settlementOwnerDetail, SettlementDriverDetail settlementDriverDetail) {
        TransportParam transportParam = buildParam(orderChild, orderGoods, settlementOwnerDetail, settlementDriverDetail);

        // 运单更新
        brokerService.orderChildUpdate(transportParam);
    }

    private TransportParam buildParam(OrderChild orderChild, OrderGoods orderGoods, SettlementOwnerDetail settlementOwnerDetail,
                                   SettlementDriverDetail settlementDriverDetail){
        String host = documentFeign.getHost().getData();

        FeignOrderVO orderInfoFeign = orderFeign.getOrderInfoFeign(orderGoods.getOrderNo());
        String ownerMobile = ownerFeign.getOwnerInfo(orderInfoFeign.getOwnerUserNo()).getData().getMobile();

        FeignAddressVO data = addressFeign.getSendAndReceiveAddress(orderChild.getSendAddressId(), orderChild.getReceiveAddressId()).getData();
        FeignAddressVO.Address receiveAddress = data.getReceiveAddress();
        FeignAddressVO.Address sendAddress = data.getSendAddress();

        SyncOrderChildVO syncOrderChildVO = driverFeign.getSyncOrderChild(orderChild.getDriverUserNo(), orderChild.getTruckOwnUserNo()).getData();
        DriverInfoFeignVo truckOwnerInfo = syncOrderChildVO.getTruckOwnerInfo();
        DriverInfoFeignVo diverInfo = syncOrderChildVO.getDiverInfo();
        BankCardVO driverBankCard = syncOrderChildVO.getDriverBankCard();
        UserIdCardVO driverUserIdCardVO = syncOrderChildVO.getDriverUserIdCardVO();
        BankCardVO truckOwnerBankCard = syncOrderChildVO.getTruckOwnerBankCard();
        UserIdCardVO truckOwnerUserIdCardVO = syncOrderChildVO.getTruckOwnerUserIdCardVO();
        DriverLicenceFeignVO driverLicenceFeignVO = syncOrderChildVO.getDriverLicenceFeignVO();

        TruckInfoFeignVo truckInfoFeignVo = truckFeign.getTruckInfoWithTransport(orderChild.getTruckId()).getData();

        InvoicingCompanyVO invoicingCompanyByGroupCode = invoicingCompanyService.getInvoicingCompanyByGroupCode(orderChild.getInvoicingCompanyGroupCode());

        // 参数组装
        TransportParam transportParam = new TransportParam();
        transportParam.setTransportPlatformCode(invoicingCompanyByGroupCode.getNetworkCargoCompanyCode());
        transportParam.setOrderCode(orderChild.getChildNo());
        transportParam.setOwnerMobile(ownerMobile);

        // 货单
        OpenOrderDTO orderInfo = new OpenOrderDTO();
        orderInfo.setSourceOrderNo(orderChild.getOrderGoodsNo());
        orderInfo.setPublishTime(DateUtils.formatDateTime(orderGoods.getPendingOrderTime()).get());
        orderInfo.setExtractTime(DateUtils.formatDateTime(orderGoods.getLastLoadTime()).get());
        orderInfo.setArriveTime(DateUtils.formatDateTime(orderGoods.getLastArriveSendTime()).get());
        orderInfo.setGoodsAmount(orderGoods.getExtractWeight());
        orderInfo.setGoodsName(orderGoods.getGoodsName());
        orderInfo.setTransPrice(Integer.valueOf(orderChild.getFreightPrice().toString()));
        orderInfo.setGoodsPrice(Integer.valueOf(orderChild.getOrderFreightPrice().toString()));

//        orderInfo.setSendCompany();
        orderInfo.setSendAddress(sendAddress.getAddress());
        orderInfo.setSendName(sendAddress.getContact());
//        orderInfo.setReceiveCompany();
        orderInfo.setReceiveAddress(receiveAddress.getAddress());
        orderInfo.setReceiveName(receiveAddress.getContact());

        orderInfo.setSendProvince(sendAddress.getProvince());
        orderInfo.setSendCity(sendAddress.getCity());
        orderInfo.setSendCounty(sendAddress.getCounty());
        orderInfo.setSendTown(sendAddress.getTown());
        orderInfo.setSendMobile(sendAddress.getContactPhone());
        orderInfo.setLoadLongitude(sendAddress.getLongitude().toString());
        orderInfo.setLoadLatitude(sendAddress.getLatitude().toString());

        orderInfo.setReceiveProvince(receiveAddress.getProvince());
        orderInfo.setReceiveCity(receiveAddress.getCity());
        orderInfo.setReceiveCounty(receiveAddress.getCounty());
        orderInfo.setReceiveTown(receiveAddress.getTown());
        orderInfo.setReceiveMobile(receiveAddress.getContactPhone());
        orderInfo.setUnloadLongitude(receiveAddress.getLongitude().toString());
        orderInfo.setUnloadLatitude(receiveAddress.getLatitude().toString());

        // 图片
        List<OpenOrderChildImageDTO> imageList = new ArrayList<>();
        List<OrderChildImage> orderChildImages = orderChildImageDao.listLoadAndUnload(orderChild.getChildNo()).get();
        for (OrderChildImage image : orderChildImages) {
            if (image.getType().equals(OrderChildImage.Type.LOAD.getCode())) {
                imageList.add(new OpenOrderChildImageDTO(2, host + image.getImage()));

            } else if (image.getType().equals(OrderChildImage.Type.UNLOAD.getCode())) {
                imageList.add(new OpenOrderChildImageDTO(21, host + image.getImage()));
            }
        }


        // 司机
        OpenOrderChildDriverDTO driverInfo = new OpenOrderChildDriverDTO();
        driverInfo.setMobile(diverInfo.getMobile());
        driverInfo.setName(diverInfo.getName());
        driverInfo.setSex(driverUserIdCardVO.getSex());
        driverInfo.setCardNo(driverUserIdCardVO.getCardNo());
        driverInfo.setIdCardAddress(driverUserIdCardVO.getAddress());
        driverInfo.setCardStartTime(driverUserIdCardVO.getCardStartTime());
        driverInfo.setCardEndTime(Objects.equals(driverUserIdCardVO.getCardLongTerm(), 1)
                ? LONG_TERM_TIME
                : driverUserIdCardVO.getCardEndTime());
        driverInfo.setCardLongTerm(driverUserIdCardVO.getCardLongTerm());
        driverInfo.setCardFrontImg(host + driverUserIdCardVO.getCardFaceImg());
        driverInfo.setCardBackImg(host + driverUserIdCardVO.getCardBackImg());
        driverInfo.setFaceCardImg(host + driverUserIdCardVO.getCardInHandImg());

        driverInfo.setLicenceNo(driverLicenceFeignVO.getLicenceNo());
        driverInfo.setLicenceIssueOrganization(driverLicenceFeignVO.getLicenceIssueOrganization());
        driverInfo.setLicenseTime(DateUtils.formatDateTime(driverLicenceFeignVO.getLicenceTime()).get());
        driverInfo.setLicenceClass(driverLicenceFeignVO.getLicenceClass());
        driverInfo.setLicenceImg(host + driverLicenceFeignVO.getLicenceImg());
        driverInfo.setLicenceBackImg(host + driverLicenceFeignVO.getLicenceBackImg());
        driverInfo.setLicenceStartTime(DateUtils.formatDateTime(driverLicenceFeignVO.getLicenceStartTime()).get());
        driverInfo.setLicenceEndTime(Objects.equals(driverLicenceFeignVO.getLicenceLongTerm(), 1)
                ? LONG_TERM_TIME
                : DateUtils.formatDateTime(driverLicenceFeignVO.getLicenceEndTime()).get());
//        driverInfo.setTransportLicenceImg(truckInfoFeignVo.getTransportLicenceImg());
        driverInfo.setOccupationalLicenceNo(driverLicenceFeignVO.getOccupationalLicenceNo());
        driverInfo.setOccupationalLicenceImg(host + driverLicenceFeignVO.getOccupationalLicenceImg());
        driverInfo.setOccupationalStartTime(DateUtils.formatDateTime(driverLicenceFeignVO.getOccupationalLicenceStartTime()).get());
        driverInfo.setOccupationalEndTime(DateUtils.formatDateTime(driverLicenceFeignVO.getOccupationalLicenceEndTime()).get());
        driverInfo.setBankCardNo(driverBankCard.getCardNo());
        driverInfo.setBankMobile(driverBankCard.getMobile());
        driverInfo.setBankName(driverBankCard.getBank());

        // 车主
        OpenOrderChildTruckOwnerDTO ownerInfo = new OpenOrderChildTruckOwnerDTO();
        ownerInfo.setMobile(truckOwnerInfo.getMobile());
        ownerInfo.setName(truckOwnerInfo.getName());
        ownerInfo.setSex(truckOwnerUserIdCardVO.getSex());
        ownerInfo.setCardNo(truckOwnerUserIdCardVO.getCardNo());
        ownerInfo.setIdCardAddress(truckOwnerUserIdCardVO.getAddress());
        ownerInfo.setCardStartTime(truckOwnerUserIdCardVO.getCardStartTime());
        ownerInfo.setCardEndTime(Objects.equals(truckOwnerUserIdCardVO.getCardLongTerm(), 1)
                ? LONG_TERM_TIME
                : truckOwnerUserIdCardVO.getCardEndTime());
        ownerInfo.setCardLongTerm(truckOwnerUserIdCardVO.getCardLongTerm());
        ownerInfo.setCardFrontImg(host + truckOwnerUserIdCardVO.getCardFaceImg());
        ownerInfo.setCardBackImg(host + truckOwnerUserIdCardVO.getCardBackImg());
        ownerInfo.setFaceCardImg(host + truckOwnerUserIdCardVO.getCardInHandImg());
        ownerInfo.setBankCardNo(truckOwnerBankCard.getCardNo());
        ownerInfo.setBankMobile(truckOwnerBankCard.getMobile());
        ownerInfo.setBankName(truckOwnerBankCard.getBank());


        // 车辆
        OpenOrderChildTruckDTO truckInfo = new OpenOrderChildTruckDTO();
        truckInfo.setTruckNo(orderChild.getTruckNo());
        truckInfo.setTruckNoColor(truckInfoFeignVo.getTruckNoColor());
//        truckInfo.setTruckNoColorCode();
        truckInfo.setModel(truckInfoFeignVo.getModel());
        truckInfo.setLoad(truckInfoFeignVo.getLoad());
        truckInfo.setGrossMass(truckInfoFeignVo.getGrossMass().intValue());
        truckInfo.setIdentifyCode(truckInfoFeignVo.getIdentifyCode());
        truckInfo.setUseNature(truckInfoFeignVo.getUseNature());
        truckInfo.setRegisterDate(DateUtils.formatDateTime(truckInfoFeignVo.getRegisterDate()).get());
        truckInfo.setLicenceIssueOrganization(truckInfoFeignVo.getLicenceIssueOrganization());
        truckInfo.setLicenceIssueDate(DateUtils.formatDateTime(truckInfoFeignVo.getLicenceIssueDate()).get());
        truckInfo.setBusinessName(truckInfoFeignVo.getBusinessName());
        truckInfo.setRoadTransportPermitNumber(truckInfoFeignVo.getRoadTransportPermitNumber());

        truckInfo.setTruckNo2(truckInfoFeignVo.getTruckNo2());
        truckInfo.setRoadTransportCertificateNo(truckInfoFeignVo.getRoadTransportCertificateNo());
        truckInfo.setLicenceImgMain(host + truckInfoFeignVo.getLicenceImgMain());
        truckInfo.setLicenceImgSecond(host + truckInfoFeignVo.getLicenceImgSecond());
        truckInfo.setLicenceImgSecondBack(host + truckInfoFeignVo.getLicenceImgSecondBack());
        truckInfo.setTransportLicenceImg(host + truckInfoFeignVo.getTransportLicenceImg());
        truckInfo.setLicenceImgMain2(host + truckInfoFeignVo.getLicenceImgMain2());
        truckInfo.setLicenceImgSecond2(host + truckInfoFeignVo.getLicenceImgSecond2());
        truckInfo.setTransportLicenceImg2(host + truckInfoFeignVo.getTransportLicenceImg2());
        truckInfo.setPowerType(StringUtils.isBlank(truckInfoFeignVo.getPowerType())
                ? PowerTypeEnum.Type.OTHER.getCode()
                : PowerTypeEnum.Type.getCodeByName(truckInfoFeignVo.getPowerType()));

        // 运单
        OpenOrderChildDTO orderChildInfo = new OpenOrderChildDTO();
        orderChildInfo.setSourceChildNo(orderChild.getChildNo());
        orderChildInfo.setSourceGoodsNo(orderChild.getOrderGoodsNo());
        orderChildInfo.setSourceOrderNo(orderChild.getOrderNo());
        orderChildInfo.setSourceSettlementNo(settlementOwnerDetail.getSettlementNo());

        orderChildInfo.setFreight(orderChild.getFreight().intValue());
        orderChildInfo.setDriverFreight(orderChild.getFreight().intValue());
        orderChildInfo.setDriverFreightPrice(orderChild.getFreightPrice().intValue());

        orderChildInfo.setFreightPrice(settlementOwnerDetail.getFreightPrice().intValue());
        orderChildInfo.setInvoiceFreight(settlementOwnerDetail.getInvoiceFreight().intValue());
        orderChildInfo.setLossFee(settlementOwnerDetail.getLossFreight().intValue());
        orderChildInfo.setLossFeePrice(settlementOwnerDetail.getLossPrice().intValue());

        orderChildInfo.setSendTare(orderChild.getLoadTare());
        orderChildInfo.setSendRough(orderChild.getLoadRough());
        orderChildInfo.setSendNet(orderChild.getLoadNet());


        orderChildInfo.setPayTime(DateUtils.formatDateTime(orderChild.getPayTime()).get());
        orderChildInfo.setLoadTime(DateUtils.formatDateTime(orderChild.getLoadTime()).get());
        orderChildInfo.setUnloadTime(DateUtils.formatDateTime(orderChild.getUnloadTime()).get());
        orderChildInfo.setPayFinishedTime(DateUtils.formatDateTime(orderChild.getConfirmTime()).get());
        orderChildInfo.setPoundTime(DateUtils.formatDateTime(settlementOwnerDetail.getPoundAuditTime()).get());

        orderChildInfo.setReceiveTare(orderChild.getUnloadTare());
        orderChildInfo.setReceiveRough(orderChild.getUnloadRough());
        orderChildInfo.setReceiveNet(orderChild.getUnloadNet());
        orderChildInfo.setInvoiceFlag(settlementOwnerDetail.getInvoiceType());
        orderChildInfo.setInvoicePlatform(settlementOwnerDetail.getInvoicingCompanyShorterName());
        orderChildInfo.setInvoiceStatus(Objects.equals(settlementOwnerDetail.getInvoiceStatus(),
                SettlementOwnerDetailEnum.InvoiceStatus.YES.getCode())? 1 : 0);

        transportParam.setOrder(orderInfo);
        transportParam.setOrderChildImage(imageList);
        transportParam.setOrderChildDriver(driverInfo);
        transportParam.setOrderChildTruckOwner(ownerInfo);
        transportParam.setOrderChildTruck(truckInfo);
        transportParam.setOrderChild(orderChildInfo);

        return transportParam;

    }
}
