package com.clx.performance.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.clx.performance.dto.OrderChildExpectDTO;
import com.clx.performance.model.OrderChild;
import com.clx.performance.model.OrderGoods;
import com.clx.performance.param.app.*;
import com.clx.performance.param.app.owner.PageOwnerOrderChildListParam;
import com.clx.performance.param.feign.CancelOrderGoodsParam;
import com.clx.performance.param.pc.*;
import com.clx.performance.vo.app.*;
import com.clx.performance.vo.app.owner.OwnerOrderChildVO;
import com.clx.performance.vo.pc.*;
import com.clx.performance.vo.pc.child.UpdateCarrierBatchCancelVO;
import com.msl.common.base.PageParam;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

import java.math.BigDecimal;
import java.util.List;


/**
 * @Author: aiqinguo
 * @Description: 运单表
 * @Date: 2023/09/18 11:34:50
 * @Version: 1.0
 */

public interface OrderChildService {

    SaveOrderChildVO saveOrderChild(OrderChildSaveParam param);
    SaveOrderChildVO doSaveOrderChild(OrderChildSaveParam param);

    void updateReject(OrderChildRejectParam param);

    void updateGotoSendAddress(OrderChildGoToSendAddressParam param);
    void updateArriveSendAddress(OrderChildArriveSendAddressParam param);
    void updateGotoReceiveAddress(OrderChildGoToReceiveAddressParam param);
    void updateArriveReceiveAddress(OrderChildArriveReceiveAddressParam param);

    void updateLoad(OrderChildLoadParam param);
    void updateUnload(OrderChildUnloadParam param);
    void updateLoadAndUnloadAgain(OrderChildLoadAndUnloadAgainParam param);

    void updateDriverConfirm(OrderChildDriverConfirmParam param);
    void updateSettlement(OrderChild orderChild);
    void updateDriverCancel(OrderChildDriverCancelParam param);

    void updateCarrierCancel(OrderChildCarrierCancelParam param);

    OrderChildVO getOrderChildInfo(String childNo);

    IPage<OrderChildVO> pageOrderChild(PageOrderChildOfDriverParam param);
    IPage<OrderChildVO> pageSearchOrderChild(PageOrderChildOfDriverSearchParam param);

    OrderChildEstimatedFreightVO getEstimatedFreight(OrderChildEstimatedFreightParam param);
    OrderChildPoundInfoVO getOrderChildPoundInfo(String childNo);
    OrderChildFreightInfoVO getOrderChildFreightInfo(String childNo);

    IPage<PageOrderChildPoundAuditVO> pagePoundAuditList(PagePoundAuditParam param);

    IPage<PageCarrierOrderChildVO> pageCarrierOrderChildList(PageCarrierOrderChildParam param);

    SXSSFWorkbook exportCarrierOrderChildList(PageCarrierOrderChildParam param);

    List<OrderChildPCVO> getOrderChildInfoByOrderGoodsNo(QueryOrderChildsListByParam param);

    CarrierOrderChildDetailVO getCarrierOrderChildDetail(String childNo);

    GoingOrderChildVO getGoingLatestOrderChild();

    Integer getOrderChildTotalByUserNo(Long userNo);

    OrderChildBussInfoVO getOrderChildBussInfo(int truckId);

    IPage<OutputMonitorOrderChildVO> getMonitorOrerChildListsByParam(PageMonitorOrderChildQCParam param);

    List<String> getOrderChildTruckByOrderNo(String orderNo);

    void orderChildExpect();

    /**
     * 查询是否存在未通过榜单审核的运单
     * @param orderNo
     * @return
     */
    List<OrderChild> selectInTransitOrderChild(String orderNo);

    List<OrderChild> selectInTransitOrderChildLtUnsettle(String orderNo);

    DriverCancelOrderChildInfo driverCancelOrderChildInfo(String orderChildNo);

    void updateOrderGoodsAmountLoad(OrderGoods orderGoods,String childNo, BigDecimal dif, Integer orderGoodsStatus);

    IPage<CustomerComplaintOrderChildVO> pageCustomerComplaintOrderChild(PageParam param);

    IPage<OwnerOrderChildVO> pageOwnerOrderChildList(PageOwnerOrderChildListParam param);

    OrderChildVO getOwnerOrderChildInfo(String childNo);

    Integer getOrderChildCheck(OrderChildCheckParam param);

    void cancelOrderChilds(CancelOrderGoodsParam param);

    OcrRecognitionResultVO ocrRecognition(OcrRecognitionParam param);

    List<OrderChildExpectDTO> getOrderChildExpect(String orderChildNo);

    void cacheOrderChildExpectData(String childNo, OrderChildExpectDTO expect);

    List<HistoryLineTranVolumeChartVO> getHistoryLineTransportVolume(String orderNo);



    UpdateCarrierBatchCancelVO updateCarrierBatchCancel(OrderChildCarrierBatchCancelParam param);
}
