package com.clx.performance.controller.pc.carrier;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.clx.performance.param.pc.carrier.PageSettlementOrderChildRiskParam;
import com.clx.performance.service.settle.SettlementOrderChildRiskService;
import com.clx.performance.vo.pc.carrier.settle.SettlementOrderChildRiskVO;
import com.msl.common.base.PageData;
import com.msl.common.convertor.aspect.UnitCovert;
import com.msl.common.result.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletResponse;

@Slf4j
@RestController
@RequestMapping(value="/pc/carrier/settlementOrderChildRisk")
@Validated
@Api(tags = "承运端-风控管理")
@AllArgsConstructor
public class SettlementOrderChildRiskController {

    private final SettlementOrderChildRiskService settlementOrderChildRiskService;


    @ApiOperation(value = "风控异常处理列表",notes = "<br>By:杨启发")
    @PostMapping("/pageSettlementOrderChildRisk")
    @UnitCovert(param = false)
    public Result<PageData<SettlementOrderChildRiskVO>> pageSettlementOrderChildRisk(@RequestBody @Validated PageSettlementOrderChildRiskParam param) {
        IPage<SettlementOrderChildRiskVO> page = settlementOrderChildRiskService.pageSettlementOrderChildRisk(param);
        return Result.page(page.getRecords(),page.getTotal(),page.getPages());
    }

    @ApiOperation(value = "导出风控异常处理",notes = "<br>By:杨启发")
    @PostMapping("/exportSettlementOrderChildRisk")
    public void exportSettlementOrderChildRisk(@RequestBody @Validated PageSettlementOrderChildRiskParam param, HttpServletResponse response) throws Exception {
        try (SXSSFWorkbook workbook = settlementOrderChildRiskService.exportSettlementOrderChildRisk(param)) {
            response.setHeader(HttpHeaders.CONTENT_TYPE, MediaType.APPLICATION_OCTET_STREAM_VALUE);
            workbook.write(response.getOutputStream());
        }
    }
}
