package com.clx.performance.controller.pc;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.clx.performance.param.pc.PagePoundAuditParam;
import com.clx.performance.param.pc.PoundAuditParam;
import com.clx.performance.service.OrderChildPoundAuditService;
import com.clx.performance.service.OrderChildService;
import com.clx.performance.vo.pc.OrderChildPoundAuditDetailVO;
import com.clx.performance.vo.pc.PageOrderChildPoundAuditVO;
import com.msl.common.base.PageData;
import com.msl.common.result.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.validation.constraints.NotBlank;


@Slf4j
@RestController
@RequestMapping(value="/pc/carrier/poundAudit")
@Validated
@Api(tags = "承运端-磅单审核")
@AllArgsConstructor
public class OrderChildPoundAuditController {

    private final OrderChildService orderChildService;

    private final OrderChildPoundAuditService orderChildPoundAuditService;

    @ApiOperation(value = "磅单审核列表",notes = "<br>By:李瑞新")
    @PostMapping("/pagePoundAuditList")
    public Result<PageData<PageOrderChildPoundAuditVO>> pagePoundAuditList(@RequestBody PagePoundAuditParam param) {
        IPage<PageOrderChildPoundAuditVO> page = orderChildService.pagePoundAuditList(param);
        return Result.page(page.getRecords(), page.getTotal(), page.getPages());
    }


    @ApiOperation(value = "磅单审核详情",notes = "<br>By:李瑞新")
    @GetMapping("/getPoundAuditDetail")
    public Result<OrderChildPoundAuditDetailVO> getPoundAuditDetail(@NotBlank(message = "运单编号不能为空") String childNo) {
        return Result.ok(orderChildPoundAuditService.getPoundAuditDetail(childNo));
    }


    @ApiOperation(value = "磅单审核接口",notes = "<br>By:李瑞新")
    @PostMapping("/updatePoundAudit")
    public Result<Object> updatePoundAudit(@RequestBody @Validated PoundAuditParam param) {
        orderChildPoundAuditService.updatePoundAudit(param);
        return Result.ok();
    }
}
