/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsign.frame.config;

import cn.com.infosec.netsign.crypto.util.Base64;
import cn.com.infosec.netsign.logger.ConsoleLogger;
import java.io.FileInputStream;
import java.util.Properties;

public class ExtendedConfig {
    private static Properties prop = null;
    private static int threadPoolCore = 70;
    private static int threadPoolMax = 300;
    private static int threadPoolQueue = 30000;
    private static boolean isCatchHandler = false;
    private static int logBuffer = 80;
    private static String syslogSystem = "local0";
    private static String syslogAccess = "local1";
    private static String syslogDebug = "local2";
    private static boolean isPrintST = true;
    private static boolean isDebug = true;
    private static boolean isSave = true;
    private static String nohupLogConfig = null;
    private static boolean isCheckCertValidity = true;
    private static String encoding = null;
    private static String jmxMonitorLevel = "none";
    public static final String JMX_MONITOR_LEVEL_NONE = "none";
    public static final String JMX_MONITOR_LEVEL_SYSTEM = "system";
    public static final String JMX_MONITOR_LEVEL_FULL = "full";
    private static int taskQueueMax = 2000;
    private static long taskQueueWatchInterval = 60000L;
    private static long serviceInfoCollectInterval = 60000L;
    private static int maxReadThread = 10;
    public static final String SHELL_FILE_NAME_CPUSTATUS = "cpustat";
    public static final String SHELL_FILE_NAME_MAXMEMORY = "maxmem";
    public static final String SHELL_FILE_NAME_FREEMEMORY = "freemem";
    public static final String SHELL_FILE_NAME_MAXHARDDISK = "maxhd";
    public static final String SHELL_FILE_NAME_FREEHARDDISK = "freehd";
    public static final String SHELL_FILE_NAME_TCPTRANSSTAT = "tcptrans";
    public static final String SHELL_FILE_NAME_TCPCONNCOUNT = "tcpcc";
    private static int projectID = 0;
    private static String algMode = "soft";
    private static String verifyProvider = "INFOSEC";
    private static String[] verifyProviders = null;
    private static String signProvider = "INFOSEC";
    private static String[] signProviders = null;
    private static String encryptProvider = "INFOSEC";
    private static String decryptProvider = "INFOSEC";
    private static int backLog = 200;
    public static final int PDF_ALLOW_ASSEMBLY = 1024;
    public static final int PDF_ALLOW_COPY = 16;
    public static final int PDF_ALLOW_DEGRADED_PRINTING = 4;
    public static final int PDF_ALLOW_FILL_IN = 256;
    public static final int PDF_ALLOW_MODIFY_ANNOTATIONS = 32;
    public static final int PDF_ALLOW_MODIFY_CONTENTS = 8;
    public static final int PDF_ALLOW_PRINTING = 2052;
    public static final int PDF_ALLOW_SCREENREADERS = 512;
    public static String subFilter = "adbe.pkcs7.detached";
    public static String signNotation = "";
    public static String stampFile = "";
    private static int[] pdfPermissions = new int[]{-1};
    private static boolean inBlackList;
    private static int[] crlCleanTimes;
    private static long reloadCRLInterval;
    private static String crlLoadMode;
    private static boolean supportsm2;
    private static boolean sm2UseHardKeyStore;
    private static boolean useHardKeyStore;
    private static boolean sm2SignUseHardALG;
    private static boolean sm2VerifyUseHardALG;
    private static String sm2Provider;
    private static String defaultSM2P10Alg;
    private static byte[] SM3CertpucID;
    private static byte[] SM3P10PucID;
    private static byte[] SM3SignpucID;
    private static byte[] SM3OCSPPucID;
    private static boolean sm2Cache;
    private static int sm2CacheSize;
    private static String sm2SignGear;
    private static String sm2VerifyGear;
    private static boolean withCertChain;
    private static boolean isAutoReloadResources;
    private static long resourceReloadInterval;
    private static boolean isAutoUnzip;
    private static String privateKeyAlg;
    private static boolean isReturnVerifyResult;
    private static boolean isReturnSignResult;
    private static boolean isSessionMonitorOpen;
    private static int maxSessionPoolSize;
    private static boolean p7VerifySupportAuthAttrs;
    private static boolean rsaSignUsingQ7;
    private static boolean sm2SignUsingQ7;
    private static boolean rsaEncUsingQ7;
    private static boolean sm2EncUsingQ7;
    private static boolean isUsingCImp;
    private static boolean envelopCache;
    private static int envelopCacheSize;
    private static String encryptGear;
    private static String decryptGear;
    private static boolean integerUnsigned;
    private static boolean isLogRespTime;
    private static long longBusinessTime;
    private static boolean isCheckBankID;
    private static boolean KLBSignOuterFields;
    private static String hardKeyStoreDevice;
    private static String hardKeyStroreBackupPassword;
    private static boolean checkWeekAlg;
    private static boolean isCacheCert;
    private static boolean isVerifyCertChain;
    private static boolean isSupportIssuerKid;
    private static boolean isIssuerDNCaseMatch;
    private static short signProviderWheel;
    private static short verifyProviderWheel;
    private static Object signProviderLock;
    private static Object verifyProviderLock;
    private static boolean needCheckOSCCAStandards;
    private static boolean SM2SigMustQ7;
    private static boolean RSASigMustQ7;
    private static boolean SM2SigMustSeq;
    private static boolean SM2SigMustUnsignedInt;
    private static boolean SM2SigMustSignedInt;

    static {
        supportsm2 = false;
        sm2UseHardKeyStore = false;
        useHardKeyStore = false;
        sm2SignUseHardALG = true;
        sm2VerifyUseHardALG = true;
        sm2Provider = null;
        defaultSM2P10Alg = "SM3withSM2";
        SM3CertpucID = null;
        SM3P10PucID = null;
        SM3SignpucID = null;
        SM3OCSPPucID = null;
        sm2Cache = false;
        sm2CacheSize = 0;
        sm2SignGear = "0/1";
        sm2VerifyGear = "0/1";
        withCertChain = false;
        isAutoReloadResources = false;
        resourceReloadInterval = 3600000L;
        isAutoUnzip = false;
        privateKeyAlg = null;
        isReturnVerifyResult = true;
        isReturnSignResult = true;
        isSessionMonitorOpen = false;
        maxSessionPoolSize = 10240;
        p7VerifySupportAuthAttrs = true;
        rsaSignUsingQ7 = false;
        sm2SignUsingQ7 = true;
        rsaEncUsingQ7 = false;
        sm2EncUsingQ7 = true;
        isUsingCImp = false;
        integerUnsigned = true;
        isLogRespTime = true;
        longBusinessTime = 500L;
        isCheckBankID = true;
        KLBSignOuterFields = true;
        hardKeyStoreDevice = null;
        hardKeyStroreBackupPassword = null;
        checkWeekAlg = false;
        isCacheCert = true;
        isVerifyCertChain = true;
        isSupportIssuerKid = true;
        isIssuerDNCaseMatch = true;
        signProviderWheel = 0;
        verifyProviderWheel = 0;
        signProviderLock = new Object();
        verifyProviderLock = new Object();
        needCheckOSCCAStandards = false;
        SM2SigMustQ7 = false;
        RSASigMustQ7 = false;
        SM2SigMustSeq = false;
        SM2SigMustUnsignedInt = false;
        SM2SigMustSignedInt = false;
    }

    public static boolean isNeedCheckOSCCAStandards() {
        return needCheckOSCCAStandards;
    }

    public static void setNeedCheckOSCCAStandards(boolean needCheckOSCCAStandards) {
        ExtendedConfig.needCheckOSCCAStandards = needCheckOSCCAStandards;
    }

    public static boolean isSM2SigMustQ7() {
        return SM2SigMustQ7;
    }

    public static boolean isRSASigMustQ7() {
        return RSASigMustQ7;
    }

    public static boolean isSM2SigMustSeq() {
        return SM2SigMustSeq;
    }

    public static boolean isSM2SigMustUnsignedInt() {
        return SM2SigMustUnsignedInt;
    }

    public static boolean isSM2SigMustSignedInt() {
        return SM2SigMustSignedInt;
    }

    public static void setSM2SigMustQ7(boolean sM2SigMustQ7) {
        SM2SigMustQ7 = sM2SigMustQ7;
    }

    public static void setRSASigMustQ7(boolean rSASigMustQ7) {
        RSASigMustQ7 = rSASigMustQ7;
    }

    public static void setSM2SigMustSeq(boolean sM2SigMustSeq) {
        SM2SigMustSeq = sM2SigMustSeq;
    }

    public static void setSM2SigMustUnsignedInt(boolean sM2SigMustUnsignedInt) {
        SM2SigMustUnsignedInt = sM2SigMustUnsignedInt;
    }

    public static void setSM2SigMustSignedInt(boolean sM2SigMustSignedInt) {
        SM2SigMustSignedInt = sM2SigMustSignedInt;
    }

    public static boolean isIssuerDNCaseMatch() {
        return isIssuerDNCaseMatch;
    }

    public static boolean isSupportIssuerKid() {
        return isSupportIssuerKid;
    }

    public static boolean isVerifyCertChain() {
        return isVerifyCertChain;
    }

    public static boolean isCacheCert() {
        return isCacheCert;
    }

    public static String getAccessFac() {
        return syslogAccess;
    }

    public static String getAlgMode() {
        return algMode;
    }

    public static int getBackLog() {
        return backLog;
    }

    public static int[] getCrlCleanTimes() {
        return crlCleanTimes;
    }

    public static String getCRLLoadMode() {
        return crlLoadMode;
    }

    public static String getDebugFac() {
        return syslogDebug;
    }

    public static String getDecryptGear() {
        return decryptGear;
    }

    public static String getDecryptProvider() {
        return decryptProvider;
    }

    public static String getDefaultSM2P10Alg() {
        return defaultSM2P10Alg;
    }

    public static String getEncoding() {
        return encoding;
    }

    public static String getEncryptGear() {
        return encryptGear;
    }

    public static String getEncryptProvider() {
        return encryptProvider;
    }

    public static int getEnvelopCacheSize() {
        return envelopCacheSize;
    }

    public static String getJmxMonitorLevel() {
        if (!(jmxMonitorLevel.equals(JMX_MONITOR_LEVEL_NONE) || jmxMonitorLevel.equals(JMX_MONITOR_LEVEL_SYSTEM) || jmxMonitorLevel.equals(JMX_MONITOR_LEVEL_FULL))) {
            jmxMonitorLevel = JMX_MONITOR_LEVEL_NONE;
        }
        return jmxMonitorLevel;
    }

    public static long getLongBusinessTime() {
        return longBusinessTime;
    }

    public static int getMaxReadThread() {
        return maxReadThread;
    }

    public static int getMaxSessionPoolSize() {
        return maxSessionPoolSize;
    }

    public static int[] getPDFPermissions() {
        return pdfPermissions;
    }

    private static int getPermissionValue(String str) {
        if (str.equalsIgnoreCase("ASSEMBLY")) {
            return 1024;
        }
        if (str.equalsIgnoreCase("COPY")) {
            return 16;
        }
        if (str.equalsIgnoreCase("DEGRADED_PRINTING")) {
            return 4;
        }
        if (str.equalsIgnoreCase("FILL_IN")) {
            return 256;
        }
        if (str.equalsIgnoreCase("MODIFY_ANNOTATIONS")) {
            return 32;
        }
        if (str.equalsIgnoreCase("MODIFY_CONTENTS")) {
            return 8;
        }
        if (str.equalsIgnoreCase("PRINTING")) {
            return 2052;
        }
        if (str.equalsIgnoreCase("SCREENREADERS")) {
            return 512;
        }
        return -1;
    }

    public static String getPrivateKeyAlg() {
        return privateKeyAlg;
    }

    public static int getProjectID() {
        return projectID;
    }

    public static long getReloadCRLInterval() {
        return reloadCRLInterval;
    }

    public static long getResourceReloadInterval() {
        return resourceReloadInterval;
    }

    public static long getServiceInfoCollectInterval() {
        return serviceInfoCollectInterval;
    }

    public static String getShellFile(String name) {
        return ExtendedConfig.loadString(name, "");
    }

    public static String getSignNotation() {
        return signNotation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getSignProvider() {
        if (signProviders != null) {
            Object object = signProviderLock;
            synchronized (object) {
                if (signProviderWheel < 0) {
                    signProviderWheel = 0;
                }
                int i = signProviderWheel % signProviders.length;
                signProviderWheel = (short)(signProviderWheel + 1);
                return signProviders[i];
            }
        }
        return signProvider;
    }

    public static int getSm2CacheSize() {
        return sm2CacheSize;
    }

    public static String getSm2Provider() {
        return sm2Provider;
    }

    public static String getSm2SignGear() {
        return sm2SignGear;
    }

    public static String getSm2VerifyGear() {
        return sm2VerifyGear;
    }

    public static byte[] getSM3OCSPPucid() {
        return SM3OCSPPucID;
    }

    public static byte[] getSm3P10Puid() {
        return SM3P10PucID;
    }

    public static byte[] getSM3pucID() {
        return SM3CertpucID;
    }

    public static byte[] getSM3SignpucID() {
        return SM3SignpucID;
    }

    public static String getStampFile() {
        return stampFile;
    }

    public static String getSubFilter() {
        return subFilter;
    }

    public static String getSystemFac() {
        return syslogSystem;
    }

    public static int getTaskQueueMax() {
        return taskQueueMax;
    }

    public static long getTaskQueueWatchInterval() {
        return taskQueueWatchInterval;
    }

    public static int getThreadPoolQueue() {
        return threadPoolQueue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getVerifyProvider() {
        if (verifyProviders != null) {
            Object object = verifyProviderLock;
            synchronized (object) {
                if (verifyProviderWheel < 0) {
                    verifyProviderWheel = 0;
                }
                int i = verifyProviderWheel % verifyProviders.length;
                verifyProviderWheel = (short)(verifyProviderWheel + 1);
                return verifyProviders[i];
            }
        }
        return verifyProvider;
    }

    public static boolean isAutoReloadResources() {
        return isAutoReloadResources;
    }

    public static boolean isAutoUnzip() {
        return isAutoUnzip;
    }

    public static boolean isCatchHandler() {
        return isCatchHandler;
    }

    public static boolean isCheckBankID() {
        return isCheckBankID;
    }

    public static boolean isCheckCertValidity() {
        return isCheckCertValidity;
    }

    public static boolean isDebug() {
        return isDebug;
    }

    public static boolean isEnvelopCache() {
        return envelopCache;
    }

    public static boolean isInBlackList() {
        return inBlackList;
    }

    public static boolean isIntegerUnsigned() {
        return integerUnsigned;
    }

    public static boolean isKLBSignOuterFields() {
        return KLBSignOuterFields;
    }

    public static boolean isLogRespTime() {
        return isLogRespTime;
    }

    public static boolean isPrintST() {
        return isPrintST;
    }

    public static boolean isReturnSignResult() {
        return isReturnSignResult;
    }

    public static boolean isReturnVerifyResult() {
        return isReturnVerifyResult;
    }

    public static boolean isRsaEncUsingQ7() {
        return rsaEncUsingQ7;
    }

    public static boolean isRSASignUsingQ7() {
        return rsaSignUsingQ7;
    }

    public static boolean isSave() {
        return isSave;
    }

    public static boolean isSessionMonitorOpen() {
        return isSessionMonitorOpen;
    }

    public static boolean isSm2Cache() {
        return sm2Cache;
    }

    public static boolean isSm2EncUsingQ7() {
        return sm2EncUsingQ7;
    }

    public static boolean isSM2SignUsehardalg() {
        return sm2SignUseHardALG;
    }

    public static boolean isSM2SignUsingQ7() {
        return sm2SignUsingQ7;
    }

    public static boolean isSM2VerifyUsehardalg() {
        return sm2VerifyUseHardALG;
    }

    public static boolean isSupportsm2() {
        return supportsm2;
    }

    public static boolean isUsehardkeystore() {
        return sm2UseHardKeyStore;
    }

    public static boolean isUsingCImp() {
        return isUsingCImp;
    }

    public static boolean isWithCertChain() {
        return withCertChain;
    }

    public static void load(String confFile) {
        prop = new Properties();
        try {
            FileInputStream in = new FileInputStream(confFile);
            prop.load(in);
            prop.list(System.out);
            isDebug = ExtendedConfig.loadBoolean("isdebug", false);
            isPrintST = ExtendedConfig.loadBoolean("isprintst", true);
            isSave = ExtendedConfig.loadBoolean("issave", false);
            nohupLogConfig = ExtendedConfig.loadString("nohuplogconfig", null);
            threadPoolCore = ExtendedConfig.loadInt("threadpoolcore", 50);
            threadPoolMax = ExtendedConfig.loadInt("threadpoolmax", 200);
            threadPoolQueue = ExtendedConfig.loadInt("threadpoolqueue", 30000);
            isCatchHandler = ExtendedConfig.loadBoolean("iscatchhandler", false);
            logBuffer = ExtendedConfig.loadInt("logbuffer", 0);
            syslogSystem = ExtendedConfig.loadString("syslogsystem", syslogSystem);
            syslogAccess = ExtendedConfig.loadString("syslogaccess", syslogAccess);
            syslogDebug = ExtendedConfig.loadString("syslogdebug", syslogDebug);
            isCheckCertValidity = ExtendedConfig.loadBoolean("checkvalidity", true);
            encoding = ExtendedConfig.loadString("encoding", "ISO8859-1");
            jmxMonitorLevel = ExtendedConfig.loadString("jmlevel", JMX_MONITOR_LEVEL_NONE);
            taskQueueMax = ExtendedConfig.loadInt("tqmax", 2000);
            taskQueueWatchInterval = ExtendedConfig.loadLong("tqwinterval", 50L);
            serviceInfoCollectInterval = ExtendedConfig.loadLong("sicinterval", 60000L);
            projectID = ExtendedConfig.loadInt("projectid", 0);
            maxReadThread = ExtendedConfig.loadInt("maxreadthread", 3);
            algMode = ExtendedConfig.loadString("algmode", "soft");
            verifyProvider = ExtendedConfig.loadString("verifyprovider", "INFOSEC");
            if (verifyProvider.indexOf(",") > 0) {
                verifyProviders = verifyProvider.split(",");
                verifyProvider = verifyProviders[0];
            }
            if ((signProvider = ExtendedConfig.loadString("signprovider", "INFOSEC")).indexOf(",") > 0) {
                signProviders = signProvider.split(",");
                signProvider = signProviders[0];
            }
            encryptProvider = ExtendedConfig.loadString("encryptprovider", "INFOSEC");
            decryptProvider = ExtendedConfig.loadString("decryptprovider", "INFOSEC");
            backLog = ExtendedConfig.loadInt("backlog", 200);
            subFilter = ExtendedConfig.loadString("subFilter", "adbe.pkcs7.detached");
            signNotation = ExtendedConfig.loadString("signnotation", signNotation);
            stampFile = ExtendedConfig.loadString("stampfile", stampFile);
            String pdfP = ExtendedConfig.loadString("pdfpermission", "");
            if (!pdfP.trim().equals("")) {
                String[] pieces = pdfP.split(",");
                pdfPermissions = new int[1];
                int i = 0;
                int length = pieces.length;
                while (i < length) {
                    int r = ExtendedConfig.getPermissionValue(pieces[i]);
                    if (r > 0) {
                        pdfPermissions[0] = pdfPermissions[0] | r;
                    }
                    ++i;
                }
            }
            inBlackList = ExtendedConfig.loadBoolean("inblacklist", false);
            crlCleanTimes = ExtendedConfig.loadCrlCleanTimes();
            reloadCRLInterval = ExtendedConfig.loadLong("reloadcrlinterval", 300000L);
            crlLoadMode = ExtendedConfig.loadString("crlloadmode", "all");
            supportsm2 = ExtendedConfig.loadBoolean("supportsm2", false);
            sm2UseHardKeyStore = useHardKeyStore = ExtendedConfig.loadBoolean("usehardkeystore", false);
            privateKeyAlg = ExtendedConfig.loadString("hardkeystore.privatekeyalg", null);
            ExtendedConfig.loadSM2UseHardAlg();
            sm2Provider = ExtendedConfig.loadString("algprovider", null);
            sm2Provider = "".equals(sm2Provider) ? null : sm2Provider;
            defaultSM2P10Alg = ExtendedConfig.loadString("defaultsm2p10alg", "SM3withSM2");
            SM3CertpucID = ExtendedConfig.loadByteArray("sm3pucid", null);
            SM3SignpucID = ExtendedConfig.loadByteArray("sm3signpucid", null);
            SM3P10PucID = ExtendedConfig.loadByteArray("sm3p10puid", null);
            SM3OCSPPucID = ExtendedConfig.loadByteArray("sm3ocspucid", null);
            sm2Cache = ExtendedConfig.loadBoolean("sm2cache", false);
            sm2CacheSize = ExtendedConfig.loadInt("sm2cachesize", 0);
            sm2SignGear = ExtendedConfig.loadString("sm2signgear", "0/1");
            sm2VerifyGear = ExtendedConfig.loadString("sm2verifygear", "0/1");
            envelopCache = ExtendedConfig.loadBoolean("envelopcache", false);
            envelopCacheSize = ExtendedConfig.loadInt("envelopcachesize", 0);
            encryptGear = ExtendedConfig.loadString("encryptgear", "0/1");
            decryptGear = ExtendedConfig.loadString("decryptgear", "0/1");
            withCertChain = ExtendedConfig.loadBoolean("withcertchain", false);
            isAutoReloadResources = ExtendedConfig.loadBoolean("isautoreloadresources", false);
            resourceReloadInterval = ExtendedConfig.loadLong("resourcereloadinterval", 3600000L);
            isAutoUnzip = ExtendedConfig.loadBoolean("isautounzip", false);
            isReturnVerifyResult = ExtendedConfig.loadBoolean("isreturnverifyresult", true);
            isReturnSignResult = ExtendedConfig.loadBoolean("isreturnsignresult", true);
            isSessionMonitorOpen = ExtendedConfig.loadBoolean("issessionmonitoropen", false);
            maxSessionPoolSize = ExtendedConfig.loadInt("maxsessionpoolsize", 10240);
            p7VerifySupportAuthAttrs = ExtendedConfig.loadBoolean("p7verifysupportauthattrs", true);
            rsaSignUsingQ7 = ExtendedConfig.loadBoolean("rsasignusingq7", false);
            sm2SignUsingQ7 = ExtendedConfig.loadBoolean("sm2signusingq7", true);
            rsaEncUsingQ7 = ExtendedConfig.loadBoolean("rsaencusingq7", false);
            sm2EncUsingQ7 = ExtendedConfig.loadBoolean("sm2encusingq7", true);
            isUsingCImp = ExtendedConfig.loadBoolean("encryptusec", false);
            integerUnsigned = ExtendedConfig.loadBoolean("integerunsigned", true);
            isLogRespTime = ExtendedConfig.loadBoolean("islogresponsetime", true);
            longBusinessTime = ExtendedConfig.loadLong("longbusinesstime", 500L);
            isCheckBankID = ExtendedConfig.loadBoolean("ischeckbankid", true);
            KLBSignOuterFields = ExtendedConfig.loadBoolean("klbsignouterfields", true);
            hardKeyStoreDevice = ExtendedConfig.loadString("hardkeystore.device", null);
            hardKeyStroreBackupPassword = ExtendedConfig.loadString("hardkeystore.backuppassword", null);
            checkWeekAlg = ExtendedConfig.loadBoolean("checkweekalg", true);
            isCacheCert = ExtendedConfig.loadBoolean("iscachecert", true);
            isVerifyCertChain = ExtendedConfig.loadBoolean("isverifycertchain", true);
            isSupportIssuerKid = ExtendedConfig.loadBoolean("issupportissuerkid", true);
            isIssuerDNCaseMatch = ExtendedConfig.loadBoolean("isissuerdncasematch", true);
            SM2SigMustQ7 = ExtendedConfig.loadBoolean("sm2sigmustq7", false);
            RSASigMustQ7 = ExtendedConfig.loadBoolean("rsasigmustq7", false);
            SM2SigMustSeq = ExtendedConfig.loadBoolean("sm2sigmustseq", false);
            SM2SigMustUnsignedInt = ExtendedConfig.loadBoolean("sm2sigmustunsignedint", false);
            SM2SigMustSignedInt = ExtendedConfig.loadBoolean("sm2sigmustsignedint", false);
            needCheckOSCCAStandards = ExtendedConfig.loadBoolean("needcheckosccastandards", false);
            in.close();
        }
        catch (Exception e) {
            ConsoleLogger.logException(e);
        }
    }

    public static String getNohupLogConfig() {
        return nohupLogConfig;
    }

    public static String setNohupLogConfig(String config) {
        nohupLogConfig = config;
        return nohupLogConfig;
    }

    private static boolean loadBoolean(String name, boolean defValue) {
        try {
            String str = prop.getProperty(name).trim().toUpperCase();
            return str.equals("TRUE") || str.equals("YES");
        }
        catch (Exception e) {
            return defValue;
        }
    }

    private static byte[] loadByteArray(String name, byte[] defValue) {
        try {
            String str = prop.getProperty(name).trim();
            if (str == null) {
                return defValue;
            }
            if (str.startsWith("base64,")) {
                str = str.substring(7);
                return Base64.decode(str);
            }
            return str.getBytes("GBK");
        }
        catch (Exception e) {
            return defValue;
        }
    }

    private static int[] loadCrlCleanTimes() {
        String timesStr = ExtendedConfig.loadString("crlcleantimes", "2");
        ConsoleLogger.logString("stampfile:" + stampFile);
        try {
            String[] pieces = timesStr.split(",");
            int[] times = new int[pieces.length];
            int i = 0;
            int length = pieces.length;
            while (i < length) {
                times[i] = Integer.parseInt(pieces[i]);
                ++i;
            }
            return times;
        }
        catch (Exception e) {
            return new int[]{2};
        }
    }

    private static int loadInt(String name, int defValue) {
        try {
            String str = prop.getProperty(name).trim();
            return Integer.parseInt(str);
        }
        catch (Exception e) {
            return defValue;
        }
    }

    private static long loadLong(String name, long defValue) {
        try {
            String str = prop.getProperty(name).trim();
            return Long.parseLong(str);
        }
        catch (Exception e) {
            return defValue;
        }
    }

    private static void loadSM2UseHardAlg() {
        String tmp = ExtendedConfig.loadString("usehardalg", "NO").toUpperCase();
        if (tmp.indexOf(",") > 0) {
            String[] pieces = tmp.split(",");
            sm2SignUseHardALG = pieces[0].equals("YES") || pieces[0].equals("TRUE");
            sm2VerifyUseHardALG = pieces[1].equals("YES") || pieces[1].equals("TRUE");
        } else {
            sm2VerifyUseHardALG = tmp.equals("YES") || tmp.equals("TRUE");
            sm2SignUseHardALG = sm2VerifyUseHardALG;
        }
    }

    private static String loadString(String name, String defValue) {
        try {
            String str = prop.getProperty(name).trim();
            return str == null ? defValue : str;
        }
        catch (Exception e) {
            return defValue;
        }
    }

    public static int logBuffer() {
        return logBuffer;
    }

    public static void main(String[] args) {
        ExtendedConfig.load("d:/extension.properties");
    }

    public static boolean p7VerifySupportAuthAttrs() {
        return p7VerifySupportAuthAttrs;
    }

    public static void setAlgMode(String algMode) {
        ExtendedConfig.algMode = algMode;
    }

    public static void setAutoUnzip(boolean isAutoUnzip) {
        ExtendedConfig.isAutoUnzip = isAutoUnzip;
    }

    public static void setDecryptProvider(String decryptProvider) {
        ExtendedConfig.decryptProvider = decryptProvider;
    }

    public static void setEncoding(String encodName) {
        encoding = encodName;
    }

    public static void setEncryptProvider(String encryptProvider) {
        ExtendedConfig.encryptProvider = encryptProvider;
    }

    public static void setSignNotation(String signNotation) {
        ExtendedConfig.signNotation = signNotation;
    }

    public static void setSignProvider(String signProvider) {
        ExtendedConfig.signProvider = signProvider;
    }

    public static void setSM3OCSPPucid(byte[] id) {
        SM3OCSPPucID = id;
    }

    public static void setSm3P10Puid(byte[] puid) {
        SM3P10PucID = puid;
    }

    public static void setSM3SignpucID(byte[] id) {
        SM3SignpucID = id;
    }

    public static void setStampFile(String stampFile) {
        ExtendedConfig.stampFile = stampFile;
    }

    public static void setVerifyProvider(String verifyProvider) {
        ExtendedConfig.verifyProvider = verifyProvider;
    }

    public static int threadPoolCore() {
        return threadPoolCore;
    }

    public static int threadPoolMax() {
        return threadPoolMax;
    }

    public static String getHardKeyStoreDevice() {
        return hardKeyStoreDevice;
    }

    public static void setHardKeyStoreDevice(String devicename) {
        hardKeyStoreDevice = devicename;
    }

    public static String getHardKeyStoreBackupPassword() {
        return hardKeyStroreBackupPassword;
    }

    public static boolean isCheckWeekAlg() {
        return checkWeekAlg;
    }
}

