package com.clx.performance.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.clx.performance.dto.CancelOrderGoodsWeightDTO;
import com.clx.performance.dto.OrderGoodsCancelWeightDTO;
import com.clx.performance.model.OrderGoods;
import com.clx.performance.model.OrderGoodsFleetOpenTruck;
import com.clx.performance.param.app.AppGoodsOrderSearchParam;
import com.clx.performance.param.pc.OrderGoodsEditParams;
import com.clx.performance.param.pc.PageOrderGoodsListParam;
import com.clx.performance.sqlProvider.OrderGoodsSqlProvider;
import com.clx.performance.vo.app.OrderGoodsAPPVO;
import com.clx.performance.vo.pc.OrderGoodsVO;
import org.apache.ibatis.annotations.*;

import java.math.BigDecimal;
import java.util.List;

/**
 * @author kavin
 * Date 2023-09-17
 * Time 16:45
 */
public interface OrderGoodsMapper extends BaseMapper<OrderGoods> {

    @SelectProvider(type = OrderGoodsSqlProvider.class, method = "getMaxOrderGoodsId")
    String getMaxOrderGoodsId();

    @SelectProvider(type = OrderGoodsSqlProvider.class, method = "pageOrderGoodsList")
    IPage<OrderGoodsVO> pageOrderGoodsList(@Param("page") Page<OrderGoodsVO> page, @Param("param") PageOrderGoodsListParam param);

    @Update(" update order_goods set " +
            " already_transport_weight = already_transport_weight+#{weight}," +
            "order_goods_status = #{orderGoodsStatus} " +
            " where id = #{id}")
    void updateOrderGoodsWeightAndStatus(@Param("id") Integer id, @Param("weight") BigDecimal orderChildWeight, @Param("orderGoodsStatus") Integer orderGoodsStatus);

    @Update(" update order_goods set " +
            " already_transport_weight = already_transport_weight - #{residueWeight}," +
            " extract_weight = already_transport_weight," +
            "order_goods_status = #{orderGoodsStatus} " +
            " where id = #{id}")
    void updateOrderGoodsWeightAlreadyAndStatus(@Param("id") Integer id, @Param("residueWeight") BigDecimal residueWeight, @Param("orderGoodsStatus") Integer orderGoodsStatus);


    @SelectProvider(type = OrderGoodsSqlProvider.class, method = "openOrderPageGoodsList")
    IPage<OrderGoodsAPPVO> openOrderPageGoodsList(@Param("page") Page<OrderGoodsAPPVO> page, @Param("orderGoodsNoList") List<String> orderGoodsNoList);

    @SelectProvider(type = OrderGoodsSqlProvider.class, method = "exclusiveOrderPageGoodsList")
    IPage<OrderGoodsAPPVO> exclusiveOrderPageGoodsList(Page<OrderGoodsAPPVO> page, List<String> param);

    @Update(" update order_goods set " +
            " order_goods_status = #{code} " +
            " where order_goods_no = #{orderGoodsNo}")
    void updateOrderGoodsStatusByOrderGoodsNo(@Param("orderGoodsNo") String orderGoodsNo, @Param("code") Integer code);

    @SelectProvider(type = OrderGoodsSqlProvider.class, method = "saveBatchEntity")
    void saveBatchEntity(List<OrderGoods> orderGoodsList);

    @UpdateProvider(type = OrderGoodsSqlProvider.class, method = "updateOrderGoodsSetResidueWeightAndAlreadyWeight")
    Integer updateOrderGoodsSetResidueWeightAndAlreadyWeight(@Param(value = "residueWeight") BigDecimal residueWeight, @Param(value = "alreadyWeight") BigDecimal alreadyWeight,@Param(value = "id") Integer id);

    @UpdateProvider(type = OrderGoodsSqlProvider.class, method = "updateOrderGoodsSetAlreadyWeight")
    Integer updateOrderGoodsSetAlreadyWeight(@Param(value = "alreadyWeight") BigDecimal alreadyWeight,@Param(value = "id") Integer id);

    @SelectProvider(type = OrderGoodsSqlProvider.class, method = "findOrderGoodsById")
    OrderGoodsVO findOrderGoodsById(Integer id);

    @UpdateProvider(type = OrderGoodsSqlProvider.class, method = "updateOrderGoods")
    Integer updateOrderGoods(@Param(value = "params") OrderGoodsEditParams orderGoodsEditParams);

    @UpdateProvider(type = OrderGoodsSqlProvider.class, method = "updateOrderGoodsSetAlreadyWeightAndStatus")
    Integer updateOrderGoodsSetAlreadyWeightAndStatus(@Param(value = "alreadyWeight") BigDecimal alreadyWeight,@Param(value = "status") Integer status,@Param(value = "id") Integer id);

    @SelectProvider(type = OrderGoodsSqlProvider.class, method = "getAlreadyTransportWeight")
    BigDecimal getAlreadyTransportWeight(@Param("orderNo") String orderNo);

    @SelectProvider(type = OrderGoodsSqlProvider.class, method = "getCancelOrderGoods")
    List<OrderGoodsAPPVO> getCancelOrderGoods(@Param(value = "param") List<String> param);

    @Select("select sum(already_transport_weight) from order_goods where order_no=#{orderNo}")
    BigDecimal sumAlreadyTransportWeightByOrderNo(@Param("orderNo")String orderNo);

    @Select("select pending_order_freight from order_goods where " +
            " send_address_id = #{sendAddressId} and" +
            " receive_address_id = #{receiveAddressId} and order_no != #{orderNo}  order by id desc limit 10 ")
    List<Double> getFreightPrice(@Param("orderNo") String orderNo,
                                 @Param("sendAddressId") Integer sendAddressId,
                                                  @Param("receiveAddressId") Integer receiveAddressId);

    @SelectProvider(type = OrderGoodsSqlProvider.class, method = "indexOrderGoodsListSearch")
    IPage<OrderGoodsAPPVO> indexOrderGoodsListSearch(@Param("page")Page<OrderGoodsAPPVO> page, @Param("param") AppGoodsOrderSearchParam param);


    @SelectProvider(type = OrderGoodsSqlProvider.class, method = "queryProcessFleetOpenTruckList")
    List<OrderGoodsFleetOpenTruck> queryProcessFleetOpenTruckList();



    @UpdateProvider(type = OrderGoodsSqlProvider.class, method = "batchCancelOrderGoods")
    void batchCancelOrderGoods(List<CancelOrderGoodsWeightDTO> cancelOrderGoodsWeight);


    @UpdateProvider(type = OrderGoodsSqlProvider.class, method = "batchUpdateOrderGoodsPaying")
    void batchUpdateOrderGoodsPaying(@Param("updateOrderGoods") List<OrderGoods> updateOrderGoods);


    @UpdateProvider(type = OrderGoodsSqlProvider.class, method = "batchCancelOrderGoodsWeight")
    void batchCancelOrderGoodsWeight(@Param("cancelOrderGoodsList") List<OrderGoodsCancelWeightDTO> cancelOrderGoodsList);

}
