package com.clx.performance.listener.trace;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.clx.performance.common.MqWrapper;
import com.clx.performance.constant.RabbitKeyTraceConstants;
import com.clx.performance.param.mq.trace.TruckTraceSyncMqParam;
import com.clx.performance.service.trace.TruckTraceMqHandlerService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * @Author: 艾庆国
 * @Description:  mq
 * @Date: 2023-10-20 16:34:40
 * @Version: 1.0
 */
@Slf4j
@Component
public class TruckTraceSyncListener {

    @Autowired
    private TruckTraceMqHandlerService truckTraceMqHandlerService;

    @RabbitListener(queues = RabbitKeyTraceConstants.TRUCK_TRACE_SYNC_QUEUE)
    public void process(Message message) {
        try{
            log.info("轨迹, 车辆轨迹同步, message:{}", new String(message.getBody()));
            process(JSON.parseObject(new String(message.getBody()), new TypeReference<MqWrapper<TruckTraceSyncMqParam>>(){}).getData());
        }catch (Exception e){
            log.info("轨迹, 车辆轨迹同步失败",e);
        }
    }

    private void process(TruckTraceSyncMqParam mq){

        truckTraceMqHandlerService.truckTracSync(mq);

    }
}
