package com.clx.performance.dao.impl.vehiclewarn;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.clx.performance.dao.vehiclewarn.VehicleWarnRangeDao;
import com.clx.performance.enums.vehiclewarn.VehicleWarnRangEnum;
import com.clx.performance.mapper.vehiclewarn.VehicleWarnRangMapper;
import com.clx.performance.model.vehiclewarn.VehicleWarnInfo;
import com.clx.performance.model.vehiclewarn.VehicleWarnRang;
import com.clx.performance.param.pc.vehiclewarn.PageVehicleWarnRangeParam;
import com.msl.common.base.Optional;
import com.msl.common.dao.impl.BaseDaoImpl;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Repository;

import java.util.List;

@Repository
public class VehicleWarnRangeDaoImpl extends BaseDaoImpl<VehicleWarnRangMapper, VehicleWarnRang, Integer> implements VehicleWarnRangeDao {


    @Override
    public List<VehicleWarnRang> ListByWarnConfigId(Integer warnConfigId) {
        return list(lQrWrapper()
                        .eq(VehicleWarnRang::getWarnConfigId, warnConfigId)
                        .eq(VehicleWarnRang::getStatus, VehicleWarnRangEnum.Status.ENABLE.getCode())
                        .orderByDesc(VehicleWarnRang::getId)
                );
    }

    @Override
    public boolean updateDisable(VehicleWarnRang item) {
        return update(lUdWrapper()
                .eq(VehicleWarnRang::getWarnConfigId, item.getWarnConfigId())
                .eq(VehicleWarnRang::getWarnRang, item.getWarnRang())
                .eq(StringUtils.isNotBlank(item.getOrderGoodsNo()), VehicleWarnRang::getOrderGoodsNo, item.getOrderGoodsNo())
                .eq(StringUtils.isNotBlank(item.getChildNo()), VehicleWarnRang::getChildNo, item.getChildNo())
                .set(VehicleWarnRang::getStatus, VehicleWarnRangEnum.Status.DISABLE.getCode())
        );
    }

    @Override
    public IPage<VehicleWarnRang> pageByParam(PageVehicleWarnRangeParam param) {
        Page<VehicleWarnRang> page = Page.of(param.getPage(), param.getPageSize());
        return baseMapper.pageByParam(page,param);
    }

    @Override
    public Optional<VehicleWarnRang> findById(Integer id) {
        return Optional.of(id)
                .map(item -> lQrWrapper()
                        .eq(VehicleWarnRang::getId, id)
                        .last("limit 1")
                )
                .map(super::getOne);
    }

}
