package com.clx.performance.controller.temp;

import com.clx.performance.config.LoadAppConfig;
import com.clx.performance.config.PerformanceSmartCompanyNoConfig;
import com.clx.performance.model.App;
import com.msl.common.open.OpenClient;
import com.msl.common.open.RequestConfig;
import com.msl.common.result.Result;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;



/**
 * 测试sdk
 *
 * @Author: jwj
 * @Description: 临时接口
 * @Date: 2024-08-27
 */
@Slf4j
@RestController
@RequestMapping(value = "/temp/sdk")
public class TempSdkController {

    @Autowired
    private LoadAppConfig loadAppConfig;

    @Autowired
    private PerformanceSmartCompanyNoConfig companyNoConfig;

    @ApiOperation(value = "weighingSignature", notes = "<br>By:jwj")
    @PostMapping("/weighingSignature")
    public Result weighingSignature(@RequestParam(value = "childNo") String childNo,
                       @RequestParam(value = "type", required = false) Integer type) {

        App app = loadAppConfig.getLmsSmartWeightApp();//对接场站配置信息
        //组装配置信息
        RequestConfig config = new RequestConfig()
                .setAppId(app.getAppNo())
                .setAppKey(app.getAppKey())
                .setGatewayUrl(app.getCallback());
        //通过运单号码查询电子磅单图片
/*        WeighingSignatureAction action = new WeighingSignatureAction();
        action.setCustomerRelationNo(String.valueOf(companyNoConfig.getCompanyNo()));
        action.setChildNo(childNo);
        action.setType(type);
        log.info("接口请求电子磅单参数,{}", action);
        Result<List<WeighingSignatureDTO>> weighSignature = OpenClient.doAction(config, action);
        log.info("接口请求电子磅单返回结果,{}", weighSignature);
        return weighSignature;*/
        return null;
    }

}
