package com.clx.performance.controller.pc.breakcontract.owner;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.clx.performance.param.pc.breakcontract.carrier.CarrierBreakContractSavePayeeParam;
import com.clx.performance.param.pc.breakcontract.carrier.CarrierBreakPayeeConfirmParam;
import com.clx.performance.param.pc.breakcontract.carrier.OwnerConfirmSettlementParam;
import com.clx.performance.param.pc.breakcontract.carrier.PageCarrierBreakContractSettlementOwnerParam;
import com.clx.performance.service.breakcontract.BreakContractSettlementOwnerService;
import com.clx.performance.vo.pc.breakcontract.carrier.CarrierBreakContractSettlementOwnerDetailVO;
import com.clx.performance.vo.pc.breakcontract.carrier.PageCarrierBreakContractSettlementOwnerVO;
import com.msl.common.base.PageData;
import com.msl.common.convertor.aspect.UnitCovert;
import com.msl.common.result.Result;
import com.msl.user.data.UserSessionData;
import com.msl.user.utils.TokenUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import javax.validation.constraints.NotBlank;
import java.net.URLEncoder;


@Slf4j
@RestController
@RequestMapping(value="/pc/owner/breakContract")
@Validated
@Api(tags = "货主端-违约结算单（货主）")
@AllArgsConstructor
public class OwnerBreakContractSettlementOwnerController {

    private final BreakContractSettlementOwnerService breakContractSettlementOwnerService;

    @ApiOperation(value = "详情",notes = "<br>By:李瑞新")
    @GetMapping("/getOwnerBreakContractSettlementOwnerDetail")
    @UnitCovert(param = false)
    public Result<CarrierBreakContractSettlementOwnerDetailVO> getOwnerBreakContractSettlementOwnerDetail(@NotBlank(message = "结算单号不能为空") String settlementNo) {
        return Result.ok(breakContractSettlementOwnerService.getCarrierBreakContractSettlementOwnerDetail(settlementNo));
    }

    @ApiOperation(value = "列表",notes = "<br>By:李瑞新")
    @PostMapping("/pageOwnerBreakContractSettlementOwnerList")
    @UnitCovert(param = false)
    public Result<PageData<PageCarrierBreakContractSettlementOwnerVO>> pageOwnerBreakContractSettlementOwnerList(@RequestBody PageCarrierBreakContractSettlementOwnerParam param) {
        UserSessionData loginUserInfo = TokenUtil.getLoginUserInfo();
        param.setOwnerUserNo(loginUserInfo.getCompanyNo());
        IPage<PageCarrierBreakContractSettlementOwnerVO> page = breakContractSettlementOwnerService.pageCarrierBreakContractSettlementOwnerList(param);
        return Result.page(page.getRecords(), page.getTotal(), page.getPages());
    }

    @ApiOperation(value = "导出")
    @PostMapping("/exportOwnerBreakContractSettlementOwnerList")
    public Result exportOwnerBreakContractSettlementOwnerList(@RequestBody  PageCarrierBreakContractSettlementOwnerParam param, HttpServletResponse response) throws Exception {
        UserSessionData loginUserInfo = TokenUtil.getLoginUserInfo();
        param.setOwnerUserNo(loginUserInfo.getCompanyNo());
        SXSSFWorkbook workbook = breakContractSettlementOwnerService.exportCarrierBreakContractSettlementOwnerList(param);
        response.setHeader(HttpHeaders.CONTENT_TYPE, MediaType.APPLICATION_OCTET_STREAM_VALUE);
        workbook.write(response.getOutputStream());
        return null;
    }

    @ApiOperation(value = "确认结算单",notes = "<br>By:李瑞新")
    @PostMapping("/updateOwnerConfirmSettlement")
    public Result updateOwnerConfirmSettlement(@RequestBody @Validated OwnerConfirmSettlementParam param) {
        breakContractSettlementOwnerService.updateConfirmSettlement(param);
        return Result.ok();
    }


    @ApiOperation(value = "付款",notes = "<br>By李瑞新")
    @PostMapping("/saveOwnerBreakContractPayee")
    public Result saveOwnerBreakContractPayee(@RequestBody @Validated CarrierBreakContractSavePayeeParam param) {
        breakContractSettlementOwnerService.saveOwnerBreakContractPayee(param);
        return Result.ok();
    }

    @ApiOperation(value = "付款确认",notes = "<br>By:李瑞新")
    @PostMapping("/updateOwnerBreakContractPayeeConfirm")
    public Result updateOwnerBreakContractPayeeConfirm(@RequestBody @Validated CarrierBreakPayeeConfirmParam param ) {
        breakContractSettlementOwnerService.updateOwnerBreakContractPayeeConfirm(param);
        return Result.ok();
    }

}
