package com.clx.performance.controller.pc;

import com.clx.performance.param.pc.SaveDriverNoticeConfigParam;
import com.clx.performance.service.DriverNoticeConfigService;
import com.clx.performance.vo.pc.DriverNoticeConfigVO;
import com.msl.common.convertor.aspect.UnitCovert;
import com.msl.common.result.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.validation.constraints.NotNull;

/**
 * @author jiangwujie
 */
@Slf4j
@RestController
@RequestMapping(value = "/pc/carrier/driverNoticeConfig")
@Validated
@Api(tags = "司机通知配置")
@AllArgsConstructor
public class DriverNoticeConfigController {

    private final DriverNoticeConfigService driverNoticeConfigService;

    @ApiOperation(value = "司机通知配置列表", notes = "<br>By:姜武杰")
    @GetMapping("/listConfig")
    @UnitCovert(param = false)
    public Result<DriverNoticeConfigVO> listConfig() {
        return Result.ok(driverNoticeConfigService.listConfig());
    }

    @ApiOperation(value = "司机通知配置详情", notes = "<br>By:姜武杰")
    @GetMapping("/getDetail")
    @UnitCovert(param = false)
    public Result<DriverNoticeConfigVO> getDetail(@NotNull(message = "id不能为空") Integer id) {
        return Result.ok(driverNoticeConfigService.getDetail(id));
    }

    @ApiOperation(value = "编辑司机通知配置", notes = "<br>By:姜武杰")
    @PostMapping("/update")
    @UnitCovert
    public Result updateConfig(@RequestBody @Validated SaveDriverNoticeConfigParam param) {
        driverNoticeConfigService.updateConfig(param);
        return Result.ok();
    }
    @ApiOperation(value = "司机通知配置启用", notes = "<br>By:姜武杰")
    @PostMapping("/enable")
    @UnitCovert
    public Result enableConfig(@ApiParam("id") @RequestParam("id") @NotNull(message = "id不能为空") @Validated Integer id) {
        driverNoticeConfigService.enableConfig(id);
        return Result.ok();
    }

    @ApiOperation(value = "司机通知配置禁用", notes = "<br>By:姜武杰")
    @PostMapping("/disable")
    @UnitCovert
    public Result disableConfig(@ApiParam("id") @RequestParam("id") @NotNull(message = "id不能为空") Integer id) {
        driverNoticeConfigService.disableConfig(id);
        return Result.ok();
    }

}
