package com.clx.performance.vo.pc;

import com.clx.performance.enums.SyncPlatformEnum;
import com.msl.common.convertor.type.MoneyOutConvert;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import java.math.BigDecimal;



@Getter
@Setter
@NoArgsConstructor
public class PageCarrierOrderChildVO {

    @ApiModelProperty(value="运单编号",example = "41441")
    private String childNo;

    @ApiModelProperty(value="运单状态",example = "1")
    private Integer status;

    @ApiModelProperty(value="订单编号",example = "41441")
    private String orderNo;

    @ApiModelProperty(value="货单编号",example = "41441")
    private String orderGoodsNo;

    @ApiModelProperty(value="货物名称",example = "煤炭")
    private String goodsName;

    @ApiModelProperty(value="司机姓名",example = "张安")
    private String driverName;

    @ApiModelProperty(value="司机手机号",example = "12222222222")
    private String driverMobile;

    @ApiModelProperty(value = "运费单价（元）", example = "1.23")
    @MoneyOutConvert
    private BigDecimal freightPrice;

    @ApiModelProperty(value="装货净重",example = "10")
    private BigDecimal loadNet;

    @ApiModelProperty(value="卸货净重",example = "41")
    private BigDecimal unloadNet;

    @ApiModelProperty(value = "装货毛重", example = "10")
    private BigDecimal loadRough;

    @ApiModelProperty(value = "装货皮重", example = "10")
    private BigDecimal loadTare;

    @ApiModelProperty(value="卸货毛重",example = "41")
    private BigDecimal unloadRough;

    @ApiModelProperty(value="卸货皮重",example = "41")
    private BigDecimal unloadTare;

    @ApiModelProperty(value="接单时间",example = "2020-01-01 10:10:10")
    private String payTime;

    @ApiModelProperty(value="完成时间",example = "2020-01-01 10:10:10")
    private String finishTime;

    @ApiModelProperty(value="磅单审核通过时间",example = "2020-01-01 10:10:10")
    private String poundAuditTime;

    @ApiModelProperty(value="发货地址",example = "吉林")
    private String sendAddress;

    @ApiModelProperty(value="收货地址",example = "山西")
    private String receiveAddress;

    @ApiModelProperty(value = "车牌号",example = "晋A12345")
    private String truckNo;

    @ApiModelProperty(value = "订单来源")
    private Integer orderSource;
    private String orderSourceMsg;
    public String getOrderSourceMsg() {
        return SyncPlatformEnum.Source.getNameByCode(orderSource);
    }

}