package com.clx.performance.param.pay;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.msl.common.enums.ResultEnum;

/**
 * 
 * 类： Result
 * 描述：接口返回结果类
 * @author wangjf
 * 时间：2017年3月23日下午3:46:50
 * 版本：v1.0
 * 修改人：wangjf
 */
public class PayResult<T> {
	
	private Integer code; // 返回结果代码，0为成功
	/**
	 * 返回结果代码
	 * 0为成功 ，其他代码请参照代码文档
	 * @return
	 */
	public Integer getCode() {
		return code;
	}

	private Long total;//总共记录数

	private Integer pageNum;//总共页数

	/**
	 * 0代表成功，其他代码请参考《返回值说明文档》 
	 * 请务必按规定填写！
	 * @param code 结果代码
	 */
	public void setCode(Integer code) {
		this.code = code;
	}

	public String getMsg() {
		return msg;
	}

	/**
	 * 错误消息，接口中的错误处理，请务必填写错误消息<br/>
	 * 当成功时消息应为“success”
	 * @param msg 错误消息
	 */
	public void setMsg(String msg) {
		this.msg = msg;
	}

	public T getData() {
		return data;
	}

	public void setData(T data) {
		this.data = data;
	}

	private String msg;
	private T data;
	/**
	 * 默认code = 0,<br/>
	 * msg = "success"
	 */
	public PayResult() {
		this.code = 0;
		this.msg = "success";
	}
	/**
	 * 默认code = 0, 
	 * msg = "success",<br/>
	 * 当成功返回结果时，可使用此方法，直接将返回结果填写即可
	 * @param data ，返回结果
	 */
	public PayResult(T data) {
		this.code = 0;
		this.msg = "success";
		this.data = data;
	}

	/**
	 * 查询列表返回成功
	 * @param data
	 * @param pageNum
	 * @param total
	 */
	public PayResult(T data, Integer pageNum, Long total) {
		this.code = 0;
		this.msg = "success";
		this.data = data;
		this.pageNum = pageNum;
		this.total = total;
	}

	/**
	 * 产生错误时，需要在枚举中拼接自定义返回的内容
	 * @param e
	 * @param msg
	 */
	public PayResult(ResultEnum e, String msg) {
		this.code = e.getCode();
		this.msg = String.format(e.getMsg(), msg);
	}

	/**
	 * 产生错误时，可以使用此构造方法，在new时直接填写错误代码及消息即可
	 * @param code
	 * @param msg
	 */
	public PayResult(Integer code, String msg) {
		this.code = code;
		this.msg = msg;
	}
	public PayResult(Integer code, String msg, T data) {
		this.code = code;
		this.msg = msg;
		this.data = data;
	}
	@JsonIgnore
	public void setResultEnum(ResultEnum e){
		this.code = e.getCode();
		this.msg = e.getMsg();
	}
	
	public PayResult(ResultEnum e) {
		this.code = e.getCode();
		this.msg = e.getMsg();
	}

	public PayResult(T data, ResultEnum e) {
		this.code = e.getCode();
		this.msg = e.getMsg();
		this.data = data;
	}

	public Long getTotal() {
		return total;
	}

	public void setTotal(Long total) {
		this.total = total;
	}

	public Integer getPageNum() {
		return pageNum;
	}

	public void setPageNum(Integer pageNum) {
		this.pageNum = pageNum;
	}

	@Override
	public String toString() {
		return "Result [code=" + code + ", msg=" + msg + ", data=" + data + "]";
	}

	/**
	 * 是否成功
	 * @return
	 */
	public boolean succeed() {
		return code != null && code == 0;
	}
}
