package com.clx.performance.service.impl.settle;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.clx.performance.dao.settle.SettlementDriverDao;
import com.clx.performance.dao.settle.SettlementDriverDetailDao;
import com.clx.performance.enums.PerformanceResultEnum;
import com.clx.performance.model.settle.SettlementDriver;
import com.clx.performance.model.settle.SettlementDriverDetail;
import com.clx.performance.param.pc.driver.BatchUpdatePayDriverSettlementParam;
import com.clx.performance.param.pc.driver.PageCarrierSettlementDriverParam;
import com.clx.performance.service.settle.SettlementDriverService;
import com.clx.performance.service.settle.SettlementMqHandlerService;
import com.clx.performance.struct.settle.SettlementDriverStruct;
import com.clx.performance.vo.pc.carrier.settle.CarrierPageSettlementDriverVO;
import com.msl.common.exception.ServiceSystemException;
import lombok.AllArgsConstructor;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Objects;

/**
 * @author liruixin
 * Date 2023-10-12
 * Time 09:43
 */
@Service
@AllArgsConstructor
public class SettlementDriverServiceImpl implements SettlementDriverService {


    SettlementDriverDao settlementDriverDao;
    SettlementDriverDetailDao settlementDriverDetailDao;
    SettlementDriverStruct settlementDriverStruct;
    SettlementMqHandlerService settlementMqHandlerService;



    @Override
    public IPage<CarrierPageSettlementDriverVO> pageCarrierSettlementDriver(PageCarrierSettlementDriverParam param) {
        IPage<SettlementDriver> page = settlementDriverDao.pageCarrierSettlementDriver(param);
        List<CarrierPageSettlementDriverVO> list = settlementDriverStruct.covertList(
                page.getRecords());
        return new Page<CarrierPageSettlementDriverVO>().setRecords(list).setTotal(page.getTotal()).setPages(page.getPages());
    }

    @Override
    public void updateBatchPayDriverSettlement(BatchUpdatePayDriverSettlementParam param) {
        if(CollectionUtils.isEmpty(param.getIds())){
            throw new ServiceSystemException(PerformanceResultEnum.DATA_NOT_FIND,"参数不能为空");
        }
        List<SettlementDriverDetail> list = settlementDriverDetailDao.findByDriverSettlementIds(param.getIds());
        if(CollectionUtils.isEmpty(list)){
            throw new ServiceSystemException(PerformanceResultEnum.DATA_NOT_FIND);
        }
        if(!Objects.equals(param.getIds().size(),list.size())){
            throw new ServiceSystemException(PerformanceResultEnum.DATA_NOT_FIND,"所选数据有误，请重新选择");
        }
        list.forEach(item-> settlementMqHandlerService.paySettlementDriver(item));
    }
}
