package com.clx.performance.service.impl.settle;

import com.clx.performance.dao.settle.SettlementOwnerDao;
import com.clx.performance.model.settle.SettlementOwner;
import com.clx.performance.model.settle.SettlementOwnerDetail;
import com.clx.performance.service.settle.CarrierSettlementOwnerService;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;

@Slf4j
@Service
@AllArgsConstructor
public class CarrierSettlementOwnerServiceImpl implements CarrierSettlementOwnerService {

    private final SettlementOwnerDao settlementOwnerDao;

    @Override
    public void saveSettlement(SettlementOwnerDetail settlementDetail) {

        SettlementOwner settlementOwner = new SettlementOwner();

        settlementOwner.setSettlementNo("");
        settlementOwner.setOwnerUserNo(settlementDetail.getOwnerUserNo());
        settlementOwner.setOwnerName(settlementDetail.getOwnerName());
        settlementOwner.setOrderNo(settlementDetail.getOrderNo());

        settlementOwner.setWeight(BigDecimal.ZERO);
        settlementOwner.setFreight(BigDecimal.ZERO);
        settlementOwner.setLossFreight(BigDecimal.ZERO);
        settlementOwner.setSettlementFreight(BigDecimal.ZERO);

        settlementOwner.setInvoiceType(settlementDetail.getInvoiceType());
        settlementOwner.setInvoiceFreight(BigDecimal.ZERO);

        settlementOwner.setPrepayFreight(BigDecimal.ZERO);


        settlementOwnerDao.saveEntity(settlementOwner);

    }

}
