package com.clx.performance.service.impl.breakcontract;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.clx.performance.dao.breakcontract.BreakContractSettlementDriverDao;
import com.clx.performance.enums.BreakContractSettlementDriverEnum;
import com.clx.performance.enums.PerformanceResultEnum;
import com.clx.performance.model.breakcontract.BreakContractSettlementDriver;
import com.clx.performance.param.pc.breakcontract.carrier.BatchUpdatePayDriverBreakContractSettlementParam;
import com.clx.performance.param.pc.breakcontract.carrier.PageCarrierBreakContractSettlementDriverParam;
import com.clx.performance.service.breakcontract.BreakContractJobHandlerService;
import com.clx.performance.service.breakcontract.BreakContractSettlementDriverService;
import com.clx.performance.struct.breakcontract.BreakContractSettlementDriverStruct;
import com.clx.performance.utils.excel.ExcelData;
import com.clx.performance.utils.excel.ExcelField;
import com.clx.performance.utils.excel.ExcelSheet;
import com.clx.performance.utils.excel.ExcelUtil;
import com.clx.performance.vo.pc.breakcontract.carrier.CarrierBreakContractSettlementDriverDetailVO;
import com.clx.performance.vo.pc.breakcontract.carrier.PageCarrierBreakContractSettlementDriverVO;
import com.msl.common.exception.ServiceSystemException;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/**
 * @author liruixin
 * Date 2023-10-24
 * Time 16:02
 */
@Service
@Slf4j
@AllArgsConstructor
public class BreakContractSettlementDriverServiceImpl implements BreakContractSettlementDriverService {

    private final BreakContractSettlementDriverDao breakContractSettlementDriverDao;
    private final BreakContractSettlementDriverStruct breakContractSettlementStruct;
    private BreakContractJobHandlerService breakContractJobHandlerService;

    @Override
    public IPage<PageCarrierBreakContractSettlementDriverVO> pageCarrierBreakContractSettlementDriverList(PageCarrierBreakContractSettlementDriverParam param) {
        IPage<BreakContractSettlementDriver> breakContractSettlementDriverDetail = breakContractSettlementDriverDao.pageCarrierBreakContractSettlementDriverList(param);
        List<PageCarrierBreakContractSettlementDriverVO> list = breakContractSettlementStruct.covertToCarrierList(breakContractSettlementDriverDetail.getRecords());
        return new Page<PageCarrierBreakContractSettlementDriverVO>().setRecords(list).setTotal(breakContractSettlementDriverDetail.getTotal()).setPages(breakContractSettlementDriverDetail.getPages());

    }

    @Override
    public SXSSFWorkbook exportCarrierBreakContractSettlementDriverList(PageCarrierBreakContractSettlementDriverParam param) {
        param.setPage(1);
        param.setPageSize(1000000);
        IPage<PageCarrierBreakContractSettlementDriverVO> settlementOwnerDetail = pageCarrierBreakContractSettlementDriverList(param);

        List<PageCarrierBreakContractSettlementDriverVO> list = settlementOwnerDetail.getRecords();

        // 组装表头
        List<ExcelField> fieldList = new ArrayList<>();
        fieldList.add(new ExcelField(0, "序号", "index", 2000));
        fieldList.add(new ExcelField(1, "结算单号", "settlementNo", 5000));
        fieldList.add(new ExcelField(2, "运单编号", "childNo", 5000));
        fieldList.add(new ExcelField(3, "车主编号", "truckOwnerNo", 5000));
        fieldList.add(new ExcelField(4, "车主名称", "truckOwnerName", 5000));

        fieldList.add(new ExcelField(5, "司机名称", "driverName", 5000));
        fieldList.add(new ExcelField(6, "违约方", "breakContractPartyType", 5000));
        fieldList.add(new ExcelField(7, "违约金额", "figure", 5000));
        fieldList.add(new ExcelField(8, "创建人", "createName", 5000));
        fieldList.add(new ExcelField(9, "创建时间", "createTime", 5000));
        fieldList.add(new ExcelField(10, "结算平台", "settlePlatform", 5000));
        fieldList.add(new ExcelField(11, "结算状态", "settleStatus", 5000));
        fieldList.add(new ExcelField(12, "结算时间", "settleTime", 5000));

        // 组装数据
        List<List<ExcelData>> dataList = new ArrayList<>();
        for (int i=0; i<list.size(); i++){

            PageCarrierBreakContractSettlementDriverVO dto = list.get(i);
            List<ExcelData> rowData = new ArrayList<>();

            rowData.add(new ExcelData(i+1));
            rowData.add(new ExcelData(dto.getSettlementNo()));
            rowData.add(new ExcelData(dto.getChildNo()));
            rowData.add(new ExcelData(dto.getTruckOwnUserNo()+""));
            rowData.add(new ExcelData(dto.getTruckOwnName()));

            rowData.add(new ExcelData(dto.getDriverName()));
            rowData.add(new ExcelData(dto.getBreakContractPartyTypeMsg()));
            rowData.add(new ExcelData(dto.getFigure().movePointLeft(2)));
            rowData.add(new ExcelData(dto.getCreateName()));
            rowData.add(new ExcelData(dto.getCreateTime()));
            rowData.add(new ExcelData(dto.getSettlePlatformMsg()));
            rowData.add(new ExcelData(dto.getSettleStatusMsg()));
            rowData.add(new ExcelData(dto.getSettleTime()));

            dataList.add(rowData);
        }

        ExcelSheet excelSheet = new ExcelSheet("车主违约结算单", "车主违约结算单", fieldList, dataList);

        //创建excel
        return ExcelUtil.create(excelSheet);
    }


    @Override
    public CarrierBreakContractSettlementDriverDetailVO getDetailBySettlementNo(String settlementNo) {
        BreakContractSettlementDriver settlement = breakContractSettlementDriverDao.selectBySettlementNo(settlementNo).orElseThrow(PerformanceResultEnum.DATA_NOT_FIND);
        CarrierBreakContractSettlementDriverDetailVO vo = breakContractSettlementStruct.convertDetail(settlement);
        return vo;
    }

    @Override
    public void updateBatchPayDriverBreakContractSettlement(BatchUpdatePayDriverBreakContractSettlementParam param) {
        if(CollectionUtils.isEmpty(param.getIds())){
            throw new ServiceSystemException(PerformanceResultEnum.DATA_NOT_FIND,"参数不能为空");
        }
        List<BreakContractSettlementDriver> list = breakContractSettlementDriverDao.listInField(BreakContractSettlementDriver :: getId,param.getIds());
        if(CollectionUtils.isEmpty(list)){
            throw new ServiceSystemException(PerformanceResultEnum.DATA_NOT_FIND);
        }

        list.forEach(item->{
            if(!Objects.equals(item.getSettleStatus(), BreakContractSettlementDriverEnum.SettleStatus.NO.getCode())){
                throw new ServiceSystemException(PerformanceResultEnum.DATA_NOT_FIND,"所选数据有误，请重新选择");
            }
        });


        list.forEach(item->breakContractJobHandlerService.pay(item.getId()));
    }
}
