package com.clx.performance.feign;

import com.clx.performance.component.ThirdComponent;
import com.msl.common.result.Result;
import feign.RequestInterceptor;
import feign.RequestTemplate;

public class FeignInterceptor implements RequestInterceptor {



  @Override
  public void apply(RequestTemplate template){
    // 通过template获取到请求体（已经被转成json）
    String jsonBody = template.requestBody().asString();
    // 构造通用的请求体
//    String url = template.feignTarget().url() + template.url();
//    Result<?> result = ThirdComponent.encryptPost(url, jsonBody, null);
//    System.out.println(result);
    try {
      jsonBody = ThirdComponent.encrypt(jsonBody);
    } catch (Exception e) {
      throw new RuntimeException(e);
    }
    template.body(jsonBody);
  }
}