package com.clx.performance.controller.thirdparty;

import com.alibaba.fastjson.JSON;
import com.nbopen.api.*;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.core.io.ClassPathResource;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;

@Slf4j
@RestController
@RequestMapping(value="/nbbank")
@Api(tags = "宁波银行回调")
public class NbBankController {

    static {
        ClassPathResource classPathResource = new ClassPathResource("bank/config-nbbank.json");
        InputStream inputStream = null;
        try {
            inputStream = classPathResource.getInputStream();
            boolean initResult = NBOpenSDK.init(inputStream);
            log.info("NBSDK初始化状态:{}", initResult);
            log.info("sdk版本信息:{}", NBOpenSDK.getVersionInfo());
        } catch (IOException e) {
            e.printStackTrace();
        }

    }

    /**
     * 解密后
     * {
     *     "data": {
     *         "clearDate": "20231205",
     *         "merId": "EFT33021200556315",
     *         "merSeqNo": "20231205165038",
     *         "payMethod": "L",
     *         "pyerInfList": [
     *             {
     *                 "coreSeqNo": "",
     *                 "customerId": "",
     *                 "pyerAcctBankName": "",
     *                 "pyerAcctBankNo": "",
     *                 "pyerAcctName": "黑玫瑰",
     *                 "pyerAcctNo": "86041110000076809",
     *                 "signNo": "00",
     *                 "transAmt": "0.01",
     *                 "transDtTm": "2023-12-05 16:54:22"
     *             }
     *         ],
     *         "realTrxAmt": "0.01",
     *         "transDate": "20231205",
     *         "transSeqNo": "2023120516503906838128gg6DOzjP",
     *         "transStatus": "00",
     *         "trxAmt": "0.01"
     *     },
     *     "head": {
     *         "rqsJrnlNo": "16071726224843844",
     *         "rspCode": "000000",
     *         "rspDate": "2023-12-05",
     *         "rspMsg": "处理成功",
     *         "rspTime": "17:13:43:943"
     *     }
     * }
     */
    @ApiOperation(value = "notify", notes = "<br>By:艾庆国")
    @RequestMapping(value = "/notify", method = RequestMethod.POST)
    public Object notify(@RequestBody Map<String, Object> body) throws Exception {

        log.info("宁波银行回调, data:{}", JSON.toJSONString(body));

        try {
            RequestApiData requestApiData = new RequestApiData();
            requestApiData.setAppkey("77667c76_3503_4c04_95f7_fc10938c7942");
            requestApiData.setData(JSON.parseObject(JSON.toJSONString(body)));
            requestApiData.setServiceId("notifyMerchant");

            RequestHead requestHead = new RequestHead();
            requestHead.setRqsJrnlNo(NBOpenSDK.getRandom());

            SDKRequest request = new SDKRequest();
            request.setData(requestApiData);
            request.setHead(requestHead);

            System.out.println("SDK请求内容: " + JSON.toJSONString(request));
            SDKResponse result = NBOpenSDK.decryptMessage(request);
            System.out.println("SDK响应结果: " + JSON.toJSONString(result));

        }catch (Exception e){
            e.printStackTrace();
            return getResultFail();
        }


        return getResultSuc();
    }

    private Object getResultSuc() throws Exception {

        Map<String, String> data = new HashMap<>();
        data.put("errorCode", "000000");
        data.put("errorMsg", "成功");

        RequestApiData requestApiData = new RequestApiData();
        requestApiData.setAppkey("77667c76_3503_4c04_95f7_fc10938c7942");
        requestApiData.setData(data);
        requestApiData.setServiceId("notifyMerchant");

        RequestHead requestHead = new RequestHead();
        requestHead.setRqsJrnlNo(NBOpenSDK.getRandom());

        SDKRequest request = new SDKRequest();
        request.setData(requestApiData);
        request.setHead(requestHead);

        log.info("加密前: "+ JSON.toJSONString(request));
        SDKResponse result = NBOpenSDK.encryptMessage(request);
        log.info("加密后: "+JSON.toJSONString(result));

        return result.getData();
    }
    private Object getResultFail() throws Exception {

        Map<String, String> data = new HashMap<>();
        data.put("errorCode", "ER001");
        data.put("errorMsg", "失败");

        RequestApiData requestApiData = new RequestApiData();
        requestApiData.setAppkey("77667c76_3503_4c04_95f7_fc10938c7942");
        requestApiData.setData(data);
        requestApiData.setServiceId("notifyMerchant");

        RequestHead requestHead = new RequestHead();
        requestHead.setRqsJrnlNo(NBOpenSDK.getRandom());

        SDKRequest request = new SDKRequest();
        request.setData(requestApiData);
        request.setHead(requestHead);

        log.info("加密前: "+ JSON.toJSONString(request));
        SDKResponse result = NBOpenSDK.encryptMessage(request);
        log.info("加密后: "+JSON.toJSONString(result));

        return result.getData();
    }

}
