package com.clx.performance.controller.pc;


import cn.hutool.json.JSONUtil;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.clx.performance.dao.OrderChildDao;
import com.clx.performance.dao.OrderGoodsDao;
import com.clx.performance.dao.settle.SettlementDriverDetailDao;
import com.clx.performance.dao.settle.SettlementOwnerDetailDao;
import com.clx.performance.enums.PerformanceResultEnum;
import com.clx.performance.feign.TransportFeignService;
import com.clx.performance.model.OrderChild;
import com.clx.performance.model.OrderGoods;
import com.clx.performance.model.settle.SettlementDriverDetail;
import com.clx.performance.model.settle.SettlementOwnerDetail;
import com.clx.performance.param.feign.transport.ThirdOrderChildBrokerParam;
import com.clx.performance.param.pc.ArtificialCancelOrderParam;
import com.clx.performance.param.pc.OrderCancelParam;
import com.clx.performance.param.pc.OrderChildCancelRecordParam;
import com.clx.performance.param.pc.PageOrderGoodsListParam;
import com.clx.performance.service.OrderCancelService;
import com.clx.performance.service.TransportSyncService;
import com.clx.performance.vo.app.OrderChildVO;
import com.clx.performance.vo.feign.transport.ThirdOrderChildBrokerResultVO;
import com.clx.performance.vo.pc.OrderGoodsVO;
import com.msl.common.base.PageData;
import com.msl.common.base.PageParam;
import com.msl.common.convertor.aspect.UnitCovert;
import com.msl.common.result.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@Slf4j
@RestController
@RequestMapping(value="/pc/order/")
@Validated
@Api(tags = "PC-订单取消")
@AllArgsConstructor
public class OrderCancelController {

    private final OrderCancelService orderCancelService;

    @Autowired
    private TransportSyncService transportSyncService;

    @Autowired
    private OrderChildDao orderChildDao;

    @Autowired
    private SettlementOwnerDetailDao settlementOwnerDetailDao;

    @Autowired
    private OrderGoodsDao orderGoodsDao;

    @Autowired
    private TransportFeignService transportFeignService;

    @Autowired
    private SettlementDriverDetailDao settlementDriverDetailDao;

    @ApiOperation(value = "承运端取消订单", notes = "<br>By:胡宇帆")
    @PostMapping("/platformCancelOrderPre")
    public Result<Object> platformCancelOrderPre(@RequestBody OrderCancelParam param) {
        orderCancelService.platformCancelOrderPre(param);
        return Result.ok();
    }

    @ApiOperation(value = "货主端取消订单", notes = "<br>By:胡宇帆")
    @PostMapping("/ownCancelOrderPre")
    public Result<Object> ownCancelOrderPre(@RequestBody OrderCancelParam param) {
        orderCancelService.ownerCancelOrderPre(param);
        return Result.ok();
    }

    @ApiOperation(value = "客服取消运单查询", notes = "<br>By:胡宇帆")
    @GetMapping("/findArtificialCancelOrder")
    public Result<OrderChildVO> findArtificialCancelOrder(@RequestParam String orderChildNo) {
        OrderChildVO vo = orderCancelService.findArtificialCancelOrder(orderChildNo);
        return Result.ok(vo);
    }

    @ApiOperation(value = "客服取消运单", notes = "<br>By:胡宇帆")
    @PostMapping("/artificialCancelOrder")
    public Result<Object> artificialCancelOrder(@RequestBody ArtificialCancelOrderParam param) {
        orderCancelService.artificialCancelOrder(param.getOrderChildNo(), param.getRemark());
        return Result.ok();
    }


    @ApiOperation(value = "取消运单记录", notes = "<br>By:胡宇帆")
    @PostMapping("/orderChildCancelRecord")
    public Result<PageData<OrderChildVO>> orderChildCancelRecord(@RequestBody OrderChildCancelRecordParam param) {
        IPage<OrderChildVO> page = orderCancelService.orderChildCancelRecord(param);
        return Result.page(page.getRecords(), page.getTotal(), page.getPages());
    }

    @ApiOperation(value = "syncTest", notes = "<br>By:胡宇帆")
    @GetMapping("/syncTest")
    public Result<String> syncTest(@RequestParam String childNo) {
        OrderChild orderChild = orderChildDao.getByChildNo(childNo).get();
        OrderGoods orderGoods = orderGoodsDao.getByOrderGoodsNo(orderChild.getOrderGoodsNo()).get();
        SettlementOwnerDetail settlementOwnerDetail = settlementOwnerDetailDao.getByChildNo(childNo).orElseThrow(PerformanceResultEnum.DATA_NOT_FIND);
        SettlementDriverDetail settlementDriverDetail = settlementDriverDetailDao.getByChildNo(childNo).orElseThrow(PerformanceResultEnum.DATA_NOT_FIND);

        ThirdOrderChildBrokerParam param = transportSyncService.generateOrderChildSync(orderChild, orderGoods, settlementOwnerDetail, settlementDriverDetail);
        log.info("=======================生成Param{}", JSONUtil.parse(param));
        String result = transportFeignService.orderChildSync(param);
        return Result.ok(result);
    }


}
