/*
 * Decompiled with CFR 0.152.
 */
package com.nbcb.callback;

import com.nbcb.sdk.aes.exception.SDKException;
import com.nbcb.sdk.aes.exception.SDKExceptionEnums;
import com.nbcb.sdk.aes.param.ConfigFile;
import com.nbcb.sdk.aes.param.KeyStoreFactory;
import com.nbcb.sdk.aes.utils.JsonUtils;
import com.nbcb.sdk.gm.SM2Utils;
import com.nbcb.sdk.gm.SM3Utils;
import com.nbcb.sdk.gm.Utils;
import com.nbcb.sdk.gm.gmnew.SM4Utils;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CommonSecurityServiceMerchant {
    private static Log log = LogFactory.getLog(CommonSecurityServiceMerchant.class);

    public static byte[] encryService(String reqJson, byte[] randomKey) throws SDKException {
        byte[] value = null;
        log.debug((Object)"\u52a0\u5bc6\u52a0\u7b7e\u5f00\u59cb\uff01");
        try {
            byte[] reqByte = reqJson.getBytes("UTF-8");
            String reqStr = CommonSecurityServiceMerchant.encryString(reqByte, randomKey);
            value = reqStr.toString().getBytes("UTF-8");
        }
        catch (Exception e) {
            if (log.isErrorEnabled()) {
                log.error((Object)"\u6267\u884c\u5b89\u5168\u7b56\u7565\u5f02\u5e38", (Throwable)e);
            }
            throw new SDKException(SDKExceptionEnums.SECURITY_ERROR);
        }
        return value;
    }

    private static String encryString(byte[] reqByte, byte[] randomKey) {
        StringBuilder reqSB = new StringBuilder("{");
        byte[] shaValue = new byte[]{};
        try {
            shaValue = SM3Utils.hash(reqByte);
            byte[] signValueBytes = SM4Utils.encryptData_ECB(randomKey, shaValue);
            JsonUtils.appendField(reqSB, "ScrtSgn", Utils.encryptByBASE64(signValueBytes), true);
            byte[] reqByAes = SM4Utils.encryptData_ECB(randomKey, reqByte);
            JsonUtils.appendField(reqSB, "ScrtData", Utils.encryptByBASE64(reqByAes), true);
            byte[] randomKeyByRSA = SM2Utils.encrypt(randomKey, KeyStoreFactory.getInstance().getOpenPublicKey());
            JsonUtils.appendField(reqSB, "ScrtKey", Utils.encryptByBASE64(randomKeyByRSA), false);
            log.debug((Object)"\u52a0\u5bc6\u52a0\u7b7e\u7ed3\u675f\uff01");
        }
        catch (Exception e) {
            e.printStackTrace();
            log.debug((Object)"\u52a0\u5bc6\u52a0\u7b7e\u5931\u8d25\uff01");
        }
        return reqSB.toString();
    }

    public static String decryService(byte[] data) throws Exception {
        String result = CommonSecurityServiceMerchant.decryString(new String(data, "UTF-8"));
        return result;
    }

    public static String decryString(String data) throws SDKException {
        log.debug((Object)"\u89e3\u5bc6\u9a8c\u7b7e\u5f00\u59cb\uff01");
        Map<String, String> map = JsonUtils.getMapObj(data);
        String scrtData = map.get("ScrtData");
        String sgn = map.get("ScrtSgn");
        String randomKey = map.get("ScrtKey");
        byte[] randomKeyByte = null;
        String respMsg = "";
        try {
            randomKeyByte = Utils.decryptByBASE64(randomKey);
            randomKeyByte = SM2Utils.decrypt(randomKeyByte, KeyStoreFactory.getInstance().getmerchantPrivatekey());
            byte[] respByte = SM4Utils.decryptData_ECB(randomKeyByte, Utils.decryptByBASE64(scrtData));
            respMsg = new String(respByte, "UTF-8");
            byte[] shaValue = SM3Utils.hash(respByte);
            byte[] signValueBytes = SM4Utils.encryptData_ECB(randomKeyByte, shaValue);
            String sgnStr = Utils.encryptByBASE64(signValueBytes);
            boolean checkSignValue = sgnStr.equals(sgn);
            if (!checkSignValue) {
                log.debug((Object)"\u9a8c\u7b7e\u5931\u8d25\uff01");
                throw new SDKException(SDKExceptionEnums.CHERSA_ERROR);
            }
            log.debug((Object)"\u89e3\u5bc6\u9a8c\u7b7e\u7ed3\u675f\uff01");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return respMsg;
    }

    public static byte[] encryService(String appkey, String reqJson, byte[] randomKey) throws SDKException {
        byte[] value = null;
        log.debug((Object)"\u52a0\u5bc6\u52a0\u7b7e\u5f00\u59cb\uff01");
        try {
            byte[] reqByte = reqJson.getBytes("UTF-8");
            String reqStr = CommonSecurityServiceMerchant.encryString(appkey, reqByte, randomKey);
            value = reqStr.toString().getBytes("UTF-8");
        }
        catch (Exception e) {
            if (log.isErrorEnabled()) {
                log.error((Object)"\u6267\u884c\u5b89\u5168\u7b56\u7565\u5f02\u5e38", (Throwable)e);
            }
            throw new SDKException(SDKExceptionEnums.SECURITY_ERROR);
        }
        return value;
    }

    private static String encryString(String appkey, byte[] reqByte, byte[] randomKey) {
        StringBuilder reqSB = new StringBuilder("{");
        byte[] shaValue = new byte[]{};
        try {
            shaValue = SM3Utils.hash(reqByte);
            byte[] signValueBytes = SM4Utils.encryptData_ECB(randomKey, shaValue);
            JsonUtils.appendField(reqSB, "ScrtSgn", Utils.encryptByBASE64(signValueBytes), true);
            byte[] reqByAes = SM4Utils.encryptData_ECB(randomKey, reqByte);
            JsonUtils.appendField(reqSB, "ScrtData", Utils.encryptByBASE64(reqByAes), true);
            byte[] randomKeyByRSA = SM2Utils.encrypt(randomKey, ConfigFile.configMap.get(appkey).getKEYSTOREFACTORY().getOpenPublicKey());
            JsonUtils.appendField(reqSB, "ScrtKey", Utils.encryptByBASE64(randomKeyByRSA), false);
            log.debug((Object)"\u52a0\u5bc6\u52a0\u7b7e\u7ed3\u675f\uff01");
        }
        catch (Exception e) {
            e.printStackTrace();
            log.debug((Object)"\u52a0\u5bc6\u52a0\u7b7e\u5931\u8d25\uff01");
        }
        return reqSB.toString();
    }

    public static String decryService(String appkey, byte[] data) throws Exception {
        String result = CommonSecurityServiceMerchant.decryString(appkey, new String(data, "UTF-8"));
        return result;
    }

    public static String decryString(String appkey, String data) throws SDKException {
        log.debug((Object)"\u89e3\u5bc6\u9a8c\u7b7e\u5f00\u59cb\uff01");
        Map<String, String> map = JsonUtils.getMapObj(data);
        String scrtData = map.get("ScrtData");
        String sgn = map.get("ScrtSgn");
        String randomKey = map.get("ScrtKey");
        byte[] randomKeyByte = null;
        String respMsg = "";
        try {
            randomKeyByte = Utils.decryptByBASE64(randomKey);
            randomKeyByte = SM2Utils.decrypt(randomKeyByte, ConfigFile.configMap.get(appkey).getKEYSTOREFACTORY().getmerchantPrivatekey());
            byte[] respByte = SM4Utils.decryptData_ECB(randomKeyByte, Utils.decryptByBASE64(scrtData));
            respMsg = new String(respByte);
            byte[] shaValue = SM3Utils.hash(respByte);
            byte[] signValueBytes = SM4Utils.encryptData_ECB(randomKeyByte, shaValue);
            String sgnStr = Utils.encryptByBASE64(signValueBytes);
            boolean checkSignValue = sgnStr.equals(sgn);
            if (!checkSignValue) {
                log.debug((Object)"\u9a8c\u7b7e\u5931\u8d25\uff01");
                throw new SDKException(SDKExceptionEnums.CHERSA_ERROR);
            }
            log.debug((Object)"\u89e3\u5bc6\u9a8c\u7b7e\u7ed3\u675f\uff01");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return respMsg;
    }
}

