/*
 * Decompiled with CFR 0.152.
 */
package com.nbcb.bouncycastle.crypto.tls;

import com.nbcb.bouncycastle.crypto.AsymmetricBlockCipher;
import com.nbcb.bouncycastle.crypto.CipherParameters;
import com.nbcb.bouncycastle.crypto.CryptoException;
import com.nbcb.bouncycastle.crypto.Digest;
import com.nbcb.bouncycastle.crypto.Signer;
import com.nbcb.bouncycastle.crypto.digests.NullDigest;
import com.nbcb.bouncycastle.crypto.encodings.PKCS1Encoding;
import com.nbcb.bouncycastle.crypto.engines.RSABlindedEngine;
import com.nbcb.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.nbcb.bouncycastle.crypto.params.ParametersWithRandom;
import com.nbcb.bouncycastle.crypto.params.RSAKeyParameters;
import com.nbcb.bouncycastle.crypto.signers.GenericSigner;
import com.nbcb.bouncycastle.crypto.signers.RSADigestSigner;
import com.nbcb.bouncycastle.crypto.tls.AbstractTlsSigner;
import com.nbcb.bouncycastle.crypto.tls.CombinedHash;
import com.nbcb.bouncycastle.crypto.tls.SignatureAndHashAlgorithm;
import com.nbcb.bouncycastle.crypto.tls.TlsUtils;

public class TlsRSASigner
extends AbstractTlsSigner {
    @Override
    public byte[] generateRawSignature(SignatureAndHashAlgorithm algorithm, AsymmetricKeyParameter privateKey, byte[] hash) throws CryptoException {
        Signer signer = this.makeSigner(algorithm, true, true, new ParametersWithRandom(privateKey, this.context.getSecureRandom()));
        signer.update(hash, 0, hash.length);
        return signer.generateSignature();
    }

    @Override
    public boolean verifyRawSignature(SignatureAndHashAlgorithm algorithm, byte[] sigBytes, AsymmetricKeyParameter publicKey, byte[] hash) throws CryptoException {
        Signer signer = this.makeSigner(algorithm, true, false, publicKey);
        signer.update(hash, 0, hash.length);
        return signer.verifySignature(sigBytes);
    }

    @Override
    public Signer createSigner(SignatureAndHashAlgorithm algorithm, AsymmetricKeyParameter privateKey) {
        return this.makeSigner(algorithm, false, true, new ParametersWithRandom(privateKey, this.context.getSecureRandom()));
    }

    @Override
    public Signer createVerifyer(SignatureAndHashAlgorithm algorithm, AsymmetricKeyParameter publicKey) {
        return this.makeSigner(algorithm, false, false, publicKey);
    }

    @Override
    public boolean isValidPublicKey(AsymmetricKeyParameter publicKey) {
        return publicKey instanceof RSAKeyParameters && !publicKey.isPrivate();
    }

    protected Signer makeSigner(SignatureAndHashAlgorithm algorithm, boolean raw, boolean forSigning, CipherParameters cp) {
        if (algorithm != null != TlsUtils.isTLSv12(this.context)) {
            throw new IllegalStateException();
        }
        if (algorithm != null && algorithm.getSignature() != 1) {
            throw new IllegalStateException();
        }
        Digest d = raw ? new NullDigest() : (algorithm == null ? new CombinedHash() : TlsUtils.createHash(algorithm.getHash()));
        Signer s = algorithm != null ? new RSADigestSigner(d, TlsUtils.getOIDForHashAlgorithm(algorithm.getHash())) : new GenericSigner(this.createRSAImpl(), d);
        s.init(forSigning, cp);
        return s;
    }

    protected AsymmetricBlockCipher createRSAImpl() {
        return new PKCS1Encoding(new RSABlindedEngine());
    }
}

