/*
 * Decompiled with CFR 0.152.
 */
package com.nbcb.bouncycastle.crypto.tls;

import com.nbcb.bouncycastle.crypto.Mac;
import com.nbcb.bouncycastle.crypto.agreement.srp.SRP6VerifierGenerator;
import com.nbcb.bouncycastle.crypto.macs.HMac;
import com.nbcb.bouncycastle.crypto.params.KeyParameter;
import com.nbcb.bouncycastle.crypto.params.SRP6GroupParameters;
import com.nbcb.bouncycastle.crypto.tls.TlsSRPIdentityManager;
import com.nbcb.bouncycastle.crypto.tls.TlsSRPLoginParameters;
import com.nbcb.bouncycastle.crypto.tls.TlsUtils;
import com.nbcb.bouncycastle.util.Strings;
import java.math.BigInteger;

public class SimulatedTlsSRPIdentityManager
implements TlsSRPIdentityManager {
    private static final byte[] PREFIX_PASSWORD = Strings.toByteArray("password");
    private static final byte[] PREFIX_SALT = Strings.toByteArray("salt");
    protected SRP6GroupParameters group;
    protected SRP6VerifierGenerator verifierGenerator;
    protected Mac mac;

    public static SimulatedTlsSRPIdentityManager getRFC5054Default(SRP6GroupParameters group, byte[] seedKey) {
        SRP6VerifierGenerator verifierGenerator = new SRP6VerifierGenerator();
        verifierGenerator.init(group, TlsUtils.createHash((short)2));
        HMac mac = new HMac(TlsUtils.createHash((short)2));
        mac.init(new KeyParameter(seedKey));
        return new SimulatedTlsSRPIdentityManager(group, verifierGenerator, mac);
    }

    public SimulatedTlsSRPIdentityManager(SRP6GroupParameters group, SRP6VerifierGenerator verifierGenerator, Mac mac) {
        this.group = group;
        this.verifierGenerator = verifierGenerator;
        this.mac = mac;
    }

    @Override
    public TlsSRPLoginParameters getLoginParameters(byte[] identity) {
        this.mac.update(PREFIX_SALT, 0, PREFIX_SALT.length);
        this.mac.update(identity, 0, identity.length);
        byte[] salt = new byte[this.mac.getMacSize()];
        this.mac.doFinal(salt, 0);
        this.mac.update(PREFIX_PASSWORD, 0, PREFIX_PASSWORD.length);
        this.mac.update(identity, 0, identity.length);
        byte[] password = new byte[this.mac.getMacSize()];
        this.mac.doFinal(password, 0);
        BigInteger verifier = this.verifierGenerator.generateVerifier(salt, identity, password);
        return new TlsSRPLoginParameters(this.group, verifier, salt);
    }
}

