/*
 * Decompiled with CFR 0.152.
 */
package com.nbcb.bouncycastle.crypto.agreement;

import com.nbcb.bouncycastle.crypto.CipherParameters;
import com.nbcb.bouncycastle.crypto.agreement.DHBasicAgreement;
import com.nbcb.bouncycastle.crypto.params.DHUPrivateParameters;
import com.nbcb.bouncycastle.crypto.params.DHUPublicParameters;
import com.nbcb.bouncycastle.util.Arrays;
import com.nbcb.bouncycastle.util.BigIntegers;
import java.math.BigInteger;

public class DHUnifiedAgreement {
    private DHUPrivateParameters privParams;

    public void init(CipherParameters key) {
        this.privParams = (DHUPrivateParameters)key;
    }

    public int getFieldSize() {
        return (this.privParams.getStaticPrivateKey().getParameters().getP().bitLength() + 7) / 8;
    }

    public byte[] calculateAgreement(CipherParameters pubKey) {
        DHUPublicParameters pubParams = (DHUPublicParameters)pubKey;
        DHBasicAgreement sAgree = new DHBasicAgreement();
        DHBasicAgreement eAgree = new DHBasicAgreement();
        sAgree.init(this.privParams.getStaticPrivateKey());
        BigInteger sComp = sAgree.calculateAgreement(pubParams.getStaticPublicKey());
        eAgree.init(this.privParams.getEphemeralPrivateKey());
        BigInteger eComp = eAgree.calculateAgreement(pubParams.getEphemeralPublicKey());
        return Arrays.concatenate(BigIntegers.asUnsignedByteArray(this.getFieldSize(), eComp), BigIntegers.asUnsignedByteArray(this.getFieldSize(), sComp));
    }
}

