package com.clx.performance.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.clx.performance.enums.OrderChildEnum;
import com.clx.performance.model.OrderChild;
import com.clx.performance.param.app.PageOrderChildOfDriverParam;
import com.clx.performance.param.app.PageOrderChildOfDriverSearchParam;
import com.clx.performance.param.pc.PageCarrierOrderChildParam;
import com.clx.performance.param.pc.PagePoundAuditParam;
import com.clx.performance.sqlProvider.OrderChildSqlProvider;
import com.clx.performance.sqlProvider.OrderGoodsSqlProvider;
import com.clx.performance.vo.app.OrderChildVO;
import com.clx.performance.vo.pc.OrderGoodsVO;
import com.clx.performance.vo.pc.PageCarrierOrderChildVO;
import com.clx.performance.vo.pc.PageOrderChildPoundAuditVO;
import org.apache.ibatis.annotations.*;

import java.time.LocalDateTime;
import java.util.List;


@Mapper
public interface OrderChildMapper extends BaseMapper<OrderChild> {

    /**
     * 司机运单列表
     * @see OrderChildSqlProvider#pageOrderChildOfDriver(Page, PageOrderChildOfDriverParam)
     */
    @SelectProvider(type = OrderChildSqlProvider.class, method = "pageOrderChildOfDriver")
    IPage<OrderChildVO> pageOrderChildOfDriver(@Param("page") Page<OrderChildVO> page, @Param("param") PageOrderChildOfDriverParam param);

    /**
     * 搜索司机运单列表
     * @see OrderChildSqlProvider#pageSearchOrderChildOfDriver(Page, PageOrderChildOfDriverSearchParam)
     */
    @SelectProvider(type = OrderChildSqlProvider.class, method = "pageSearchOrderChildOfDriver")
    IPage<OrderChildVO> pageSearchOrderChildOfDriver(@Param("page") Page<OrderChildVO> page, @Param("param") PageOrderChildOfDriverSearchParam param);


    @SelectProvider(type = OrderChildSqlProvider.class, method = "pagePoundAuditList")
    IPage<PageOrderChildPoundAuditVO> pagePoundAuditList(@Param("page") Page<PageOrderChildPoundAuditVO> page, @Param("param") PagePoundAuditParam param);

    @SelectProvider(type = OrderChildSqlProvider.class, method = "pageCarrierOrderChildList")
    IPage<PageCarrierOrderChildVO> pageCarrierOrderChildList(@Param("page") Page<PageCarrierOrderChildVO> page, @Param("param") PageCarrierOrderChildParam param);

    @Select("select count(1) from order_child where order_goods_no = #{orderGoodsNo} and status < 110")
    int countValidByOrderGoodsNo(String orderGoodsNo);

    @UpdateProvider(type = OrderChildSqlProvider.class, method = "batchUpdateOrderChildStatus")
    Integer updateOrderGoodsSetResidueWeight(@Param(value = "status") Integer status, @Param(value = "remark") String remark,
                                             @Param(value = "cancelTime") String cancelTime, @Param(value = "finishTime") String finishTime,
                                             @Param(value = "childNoList") List<String> childNoList);


    @SelectProvider(type = OrderChildSqlProvider.class, method = "findArtificialCancelOrder")
    OrderChildVO findArtificialCancelOrder(@Param("orderChildNo") String orderChildNo);

    @SelectProvider(type = OrderChildSqlProvider.class, method = "orderChildCancelRecord")
    IPage<OrderChildVO> orderChildCancelRecord(@Param("page")Page<OrderGoodsVO> page);
}