package com.clx.performance.service;

import com.clx.performance.model.ThirdPartRequestLog;
import com.msl.common.base.Optional;
import com.msl.common.result.Result;

public interface ThirdPartRequestLogService {

    /**
     * 保存第三方接口调用记录
     *
     * @param log
     */
    void save(ThirdPartRequestLog log);

    /**
     * 修改第三方接口返回值
     *
     * @param logId
     * @param result
     */
    void updateResult(Integer logId, Result<?> result);

    /**
     * 修改重试次数
     *
     * @param logId
     * @param retryTimes
     */
    void updateLogRetryTimes(Integer logId, Integer retryTimes);

    /**
     * 根据id 查询
     */
    Optional<ThirdPartRequestLog> getById(Integer id);
}
