package com.clx.performance.vo.pc.carrier.settle;

import com.msl.common.convertor.type.MoneyOutConvert;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;
import io.swagger.v3.oas.annotations.media.Schema;
import java.time.LocalDateTime;
import java.math.BigDecimal;

/**
* @Author: aiqinguo
* @Description: 平台服务费
* @Date: 2024/06/18 15:10:40
* @Version: 1.0
*/

@Getter
@Setter
@ToString
@NoArgsConstructor
public class SettlementPlatformServiceFeeVO {

    @Schema(description = "id", example = "")
    private Integer id;
    @Schema(description = "运单编号", example = "")
    private String childNo;
    @Schema(description = "车主用户编号", example = "")
    private Long driverUserNo;
    @Schema(description = "车主名称", example = "")
    private String driverName;
    @Schema(description = "司机手机号", example = "")
    private String driverMobile;
    @Schema(description = "发货地址id", example = "")
    private Integer sendAddressId;
    @Schema(description = "发货地址", example = "")
    private String sendAddress;
    @Schema(description = "收货地址id", example = "")
    private Integer receiveAddressId;
    @Schema(description = "收货地址", example = "")
    private String receiveAddress;
    @Schema(description = "车牌号", example = "")
    private String truckNo;
    @MoneyOutConvert
    @Schema(description = "结算金额（分）", example = "")
    private BigDecimal settlementFreight;
    @MoneyOutConvert
    @Schema(description = "开票服务费（分）", example = "")
    private BigDecimal invoiceServiceFee;
    @Schema(description = "开票服务率%", example = "")
    private BigDecimal invoiceServiceFeeRate;
    @Schema(description = "创建时间", example = "")
    private String createTime;

}