package com.clx.performance.vo.pc.broker;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

@Getter
@Setter
@ToString
@NoArgsConstructor
public class OpenOrderChildImageDTO {

    private static final long serialVersionUID = 1L;

    @Schema(description = "图片类型", example = "2: 装车磅单照片 21：收货过磅单", required = true)
    private Integer type;
    @Schema(description = "图片相对地址", example = "", required = true)
    private String image;

    public OpenOrderChildImageDTO(Integer type, String image) {
        this.type = type;
        this.image = image;
    }
}
