package com.clx.performance.vo.pc.breakcontract.carrier;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

import java.math.BigDecimal;
import java.util.Map;

/**
 * @author liruixin
 * Date 2023-10-24
 * Time 16:02
 */
@Getter
@Setter
@ToString
@NoArgsConstructor
public class BreakContractOwnerRuleVO {
    @Schema(description="id")
    private Integer id;

    @Schema(description = "违约方案名称", example = "方案1")
    private String name;

    @Schema(description = "违约方案文件", example = "url")
    private String file;

    @Schema(description = "状态：1启用 2禁用", example = "1")
    private Integer status;

    @Schema(description="创建时间")
    private String createTime;

    @Schema(description="修改时间")
    private String modifiedTime;

    @Schema(description = "自动规则")
    private Map<String, String> rule;

    @Getter
    @Setter
    @ToString
    @NoArgsConstructor
    public static class AutoRule{

        @Schema(description = "订单吨数减少")
        private OrderAmountReduceRule orderAmountReduceRule;
        @Schema(description = "订单取消")
        private OrderCancelRule orderCancelRule;
    }

    @Getter
    @Setter
    @ToString
    @NoArgsConstructor
    public static class ManualRule{

        private Integer id;
    }

    @Getter
    @Setter
    @ToString
    @NoArgsConstructor
    public static class OrderAmountReduceRule {
        @Schema(description = "挂单前：总运费*X%", example = "1.23")
        private BigDecimal beforeRatio;
        @Schema(description = "挂单后：总运费*X%", example = "1.23")
        private BigDecimal afterRatio;
    }

    @Getter
    @Setter
    @ToString
    @NoArgsConstructor
    public static class OrderCancelRule {
        @Schema(description = "挂单前，总运费*X%", example = "1.23")
        private BigDecimal beforeRatio;
        @Schema(description = "挂单后，总运费*X%", example = "1.23")
        private BigDecimal afterRatio;
        @Schema(description = "挂单后，车辆违约金X元/小时.车", example = "1.23")
        private BigDecimal afterFigurePerHour;
    }

}
